import os,re
import torch
import torch.distributed as dist
import argparse
import functools
import gc
import logging
import math
import random
import shutil
from pathlib import Path
import copy
import deepspeed
import inspect

import datasets
import numpy as np
import torch.nn.functional as F
from torch.utils.checkpoint import checkpoint

import transformers
from datasets import concatenate_datasets, load_dataset
from huggingface_hub import create_repo, upload_folder
from packaging import version
from torchvision import transforms
from torchvision.transforms.functional import crop
from tqdm.auto import tqdm
from transformers import AutoTokenizer, PretrainedConfig, AutoModel

import diffusers
from diffusers import AutoencoderKL, DDPMScheduler, StableDiffusionXLPipeline, UNet2DConditionModel
from diffusers.optimization import get_scheduler
from diffusers.training_utils import EMAModel, compute_snr
from diffusers.utils import check_min_version, is_wandb_available
from diffusers.utils.hub_utils import load_or_create_model_card, populate_model_card
from diffusers.utils.import_utils import is_xformers_available
from diffusers.utils.torch_utils import is_compiled_module,randn_tensor

from dataset_mllm import DataModuleCustom

from transformers.models.qwen2.tokenization_qwen2 import Qwen2Tokenizer
from proj import create_proj3

from einops import rearrange
from accelerate.state import AcceleratorState

from typing import Callable, List, Optional, Union
from transformers import T5Tokenizer,MT5EncoderModel,AutoModel,AutoModelForCausalLM
from transformers import CLIPTextModel, CLIPTextModelWithProjection, CLIPTokenizer
from transformers import T5EncoderModel, T5TokenizerFast, CLIPTokenizer, CLIPTextModel,T5ForConditionalGeneration,AutoProcessor

from diffusers.schedulers import FlowMatchEulerDiscreteScheduler
from diffusers.models.transformers import FluxTransformer2DModel
from diffusers.loaders.lora_pipeline import SD3LoraLoaderMixin
from diffusers.training_utils import compute_density_for_timestep_sampling, compute_loss_weighting_for_sd3
from transformers.utils import ContextManagers
from core.data.dataloader import Preprocess
from peft import LoraConfig
from peft import LoraConfig, inject_adapter_in_model, set_peft_model_state_dict
from diffusers.loaders.lora_pipeline import SD3LoraLoaderMixin
from diffusers.utils import get_peft_kwargs,get_adapter_name

import time

from core.pipeline import train_and_infer as tai
from deepspeed.utils.groups import _ZERO_PARAM_INTRA_PARALLEL_GROUP, _DATA_PARALLEL_GROUP
from torch.utils.data.distributed import DistributedSampler
from torch.nn.parallel import DistributedDataParallel

def normalize(logit):
    mean = logit.mean(dim=-1, keepdims=True)
    stdv = logit.std(dim=-1, keepdims=True)
    return (logit - mean) / (1e-7 + stdv)

def parse_args(input_args=None):
    parser = argparse.ArgumentParser(description="Simple example of a training script.")
    parser.add_argument(
        "--pretrained_model_name_or_path",
        type=str,
        required=False,
        help="Path to pretrained model or model identifier from huggingface.co/models.",
    )
    parser.add_argument(
        "--pretrained_vae_model_name_or_path",
        type=str,
        default=None,
        help="Path to pretrained VAE model with better numerical stability. More details: https://github.com/huggingface/diffusers/pull/4038.",
    )
    parser.add_argument(
        "--revision",
        type=str,
        default=None,
        required=False,
        help="Revision of pretrained model identifier from huggingface.co/models.",
    )
    parser.add_argument(
        "--variant",
        type=str,
        default=None,
        help="Variant of the model files of the pretrained model identifier from huggingface.co/models, 'e.g.' fp16",
    )
    parser.add_argument(
        "--dataset_name",
        type=str,
        default=None,
        help=(
            "The name of the Dataset (from the HuggingFace hub) to train on (could be your own, possibly private,"
            " dataset). It can also be a path pointing to a local copy of a dataset in your filesystem,"
            " or to a folder containing files that 🤗 Datasets can understand."
        ),
    )
    parser.add_argument(
        "--dataset_config_name",
        type=str,
        default=None,
        help="The config of the Dataset, leave as None if there's only one config.",
    )
    parser.add_argument(
        "--train_data_dir",
        type=str,
        default=None,
        help=(
            "A folder containing the training data. Folder contents must follow the structure described in"
            " https://huggingface.co/docs/datasets/image_dataset#imagefolder. In particular, a `metadata.jsonl` file"
            " must exist to provide the captions for the images. Ignored if `dataset_name` is specified."
        ),
    )
    parser.add_argument(
        "--image_column", type=str, default="image", help="The column of the dataset containing an image."
    )
    parser.add_argument(
        "--caption_column",
        type=str,
        default="text",
        help="The column of the dataset containing a caption or a list of captions.",
    )
    parser.add_argument(
        "--validation_prompt",
        type=str,
        default=None,
        help="A prompt that is used during validation to verify that the model is learning.",
    )
    parser.add_argument(
        "--num_validation_images",
        type=int,
        default=4,
        help="Number of images that should be generated during validation with `validation_prompt`.",
    )
    parser.add_argument(
        "--validation_epochs",
        type=int,
        default=1,
        help=(
            "Run fine-tuning validation every X epochs. The validation process consists of running the prompt"
            " `args.validation_prompt` multiple times: `args.num_validation_images`."
        ),
    )
    parser.add_argument(
        "--max_train_samples",
        type=int,
        default=None,
        help=(
            "For debugging purposes or quicker training, truncate the number of training examples to this "
            "value if set."
        ),
    )
    parser.add_argument(
        "--proportion_empty_prompts",
        type=float,
        default=0,
        help="Proportion of image prompts to be replaced with empty strings. Defaults to 0 (no prompt replacement).",
    )
    parser.add_argument(
        "--output_dir",
        type=str,
        default="sdxl-model-finetuned",
        help="The output directory where the model predictions and checkpoints will be written.",
    )
    parser.add_argument(
        "--cache_dir",
        type=str,
        default=None,
        help="The directory where the downloaded models and datasets will be stored.",
    )
    parser.add_argument("--seed", type=int, default=None, help="A seed for reproducible training.")

    parser.add_argument(
        "--random_flip",
        action="store_true",
        help="whether to randomly flip images horizontally",
    )
    # parser.add_argument(
    #     "--train_batch_size", type=int, default=16, help="Batch size (per device) for the training dataloader."
    # )
    parser.add_argument("--num_train_epochs", type=int, default=100)
    parser.add_argument(
        "--max_train_steps",
        type=int,
        default=200000,
        help="Total number of training steps to perform.  If provided, overrides num_train_epochs.",
    )
    parser.add_argument(
        "--checkpointing_steps",
        type=int,
        default=500,
        help=(
            "Save a checkpoint of the training state every X updates. These checkpoints can be used both as final"
            " checkpoints in case they are better than the last checkpoint, and are also suitable for resuming"
            " training using `--resume_from_checkpoint`."
        ),
    )
    parser.add_argument(
        "--checkpoints_total_limit",
        type=int,
        default=None,
        help=("Max number of checkpoints to store."),
    )
    parser.add_argument(
        "--resume_from_checkpoint",
        type=str,
        default=None,
        help=(
            "Whether training should be resumed from a previous checkpoint. Use a path saved by"
            ' `--checkpointing_steps`, or `"latest"` to automatically select the last available checkpoint.'
        ),
    )
    parser.add_argument(
        "--gradient_accumulation_steps",
        type=int,
        default=1,
        help="Number of updates steps to accumulate before performing a backward/update pass.",
    )
    parser.add_argument(
        "--gradient_checkpointing",
        action="store_true",
        help="Whether or not to use gradient checkpointing to save memory at the expense of slower backward pass.",
    )
    parser.add_argument(
        "--learning_rate",
        type=float,
        default=1e-4,
        help="Initial learning rate (after the potential warmup period) to use.",
    )
    parser.add_argument(
        "--lr_scheduler",
        type=str,
        default="constant",
        help=(
            'The scheduler type to use. Choose between ["linear", "cosine", "cosine_with_restarts", "polynomial",'
            ' "constant", "constant_with_warmup"]'
        ),
    )
    parser.add_argument(
        "--lr_warmup_steps", type=int, default=500, help="Number of steps for the warmup in the lr scheduler."
    )
    parser.add_argument(
        "--timestep_bias_strategy",
        type=str,
        default="none",
        choices=["earlier", "later", "range", "none"],
        help=(
            "The timestep bias strategy, which may help direct the model toward learning low or high frequency details."
            " Choices: ['earlier', 'later', 'range', 'none']."
            " The default is 'none', which means no bias is applied, and training proceeds normally."
            " The value of 'later' will increase the frequency of the model's final training timesteps."
        ),
    )
    parser.add_argument(
        "--timestep_bias_multiplier",
        type=float,
        default=1.0,
        help=(
            "The multiplier for the bias. Defaults to 1.0, which means no bias is applied."
            " A value of 2.0 will double the weight of the bias, and a value of 0.5 will halve it."
        ),
    )
    parser.add_argument(
        "--timestep_bias_begin",
        type=int,
        default=0,
        help=(
            "When using `--timestep_bias_strategy=range`, the beginning (inclusive) timestep to bias."
            " Defaults to zero, which equates to having no specific bias."
        ),
    )
    parser.add_argument(
        "--timestep_bias_end",
        type=int,
        default=1000,
        help=(
            "When using `--timestep_bias_strategy=range`, the final timestep (inclusive) to bias."
            " Defaults to 1000, which is the number of timesteps that Stable Diffusion is trained on."
        ),
    )
    parser.add_argument(
        "--timestep_bias_portion",
        type=float,
        default=0.25,
        help=(
            "The portion of timesteps to bias. Defaults to 0.25, which 25% of timesteps will be biased."
            " A value of 0.5 will bias one half of the timesteps. The value provided for `--timestep_bias_strategy` determines"
            " whether the biased portions are in the earlier or later timesteps."
        ),
    )
    parser.add_argument(
        "--snr_gamma",
        type=float,
        default=None,
        help="SNR weighting gamma to be used if rebalancing the loss. Recommended value is 5.0. "
        "More details here: https://arxiv.org/abs/2303.09556.",
    )
    parser.add_argument("--use_ema", action="store_true", help="Whether to use EMA model.")
    parser.add_argument(
        "--allow_tf32",
        action="store_true",
        help=(
            "Whether or not to allow TF32 on Ampere GPUs. Can be used to speed up training. For more information, see"
            " https://pytorch.org/docs/stable/notes/cuda.html#tensorfloat-32-tf32-on-ampere-devices"
        ),
    )
    parser.add_argument(
        "--dataloader_num_workers",
        type=int,
        default=0,
        help=(
            "Number of subprocesses to use for data loading. 0 means that the data will be loaded in the main process."
        ),
    )
    parser.add_argument(
        "--use_8bit_adam", action="store_true", help="Whether or not to use 8-bit Adam from bitsandbytes."
    )
    parser.add_argument("--adam_beta1", type=float, default=0.9, help="The beta1 parameter for the Adam optimizer.")
    parser.add_argument("--adam_beta2", type=float, default=0.999, help="The beta2 parameter for the Adam optimizer.")
    parser.add_argument("--adam_weight_decay", type=float, default=1e-2, help="Weight decay to use.")
    parser.add_argument("--adam_epsilon", type=float, default=1e-08, help="Epsilon value for the Adam optimizer")
    parser.add_argument("--max_grad_norm", default=1.0, type=float, help="Max gradient norm.")
    parser.add_argument("--hub_token", type=str, default=None, help="The token to use to push to the Model Hub.")
    parser.add_argument(
        "--prediction_type",
        type=str,
        default=None,
        help="The prediction_type that shall be used for training. Choose between 'epsilon' or 'v_prediction' or leave `None`. If left to `None` the default prediction type of the scheduler: `noise_scheduler.config.prediction_type` is chosen.",
    )
    parser.add_argument(
        "--hub_model_id",
        type=str,
        default=None,
        help="The name of the repository to keep in sync with the local `output_dir`.",
    )
    parser.add_argument(
        "--logging_dir",
        type=str,
        default="logs",
        help=(
            "[TensorBoard](https://www.tensorflow.org/tensorboard) log directory. Will default to"
            " *output_dir/runs/**CURRENT_DATETIME_HOSTNAME***."
        ),
    )
    parser.add_argument(
        "--report_to",
        type=str,
        default="tensorboard",
        help=(
            'The integration to report the results and logs to. Supported platforms are `"tensorboard"`'
            ' (default), `"wandb"` and `"comet_ml"`. Use `"all"` to report to all integrations.'
        ),
    )
    parser.add_argument(
        "--mixed_precision",
        type=str,
        default="bf16",
        choices=["no", "fp16", "bf16"],
        help=(
            "Whether to use mixed precision. Choose between fp16 and bf16 (bfloat16). Bf16 requires PyTorch >="
            " 1.10.and an Nvidia Ampere GPU.  Default to the value of accelerate config of the current system or the"
            " flag passed with the `accelerate.launch` command. Use this argument to override the accelerate config."
        ),
    )
    parser.add_argument("--local_rank", type=int, default=-1, help="For distributed training: local_rank")
    parser.add_argument("--noise_offset", type=float, default=0, help="The scale of noise offset.")

    parser.add_argument("--load_ckpt_id", type=str, default="1")
    parser.add_argument("--load_ckpt_path", type=str)
    parser = DataModuleCustom.add_data_specific_args(parser)


    if input_args is not None:
        args = parser.parse_args(input_args)
    else:
        args = parser.parse_args()

    env_local_rank = int(os.environ.get("LOCAL_RANK", -1))
    if env_local_rank != -1 and env_local_rank != args.local_rank:
        args.local_rank = env_local_rank



    if args.proportion_empty_prompts < 0 or args.proportion_empty_prompts > 1:
        raise ValueError("`--proportion_empty_prompts` must be in the range [0, 1].")

    return args


def getActivation(activation,name):
    # the hook signature
    def hook(model, input, output):
        activation[name] = output
    return hook
def getActivationList(lists):
    # the hook signature
    def hook(model, input, output):
        lists.append(output)
        # if isinstance(output, tuple):
        #     print(f"len(output): {len(output)}")
        #     if len(output) > 1:
        #         for index, data in enumerate(output):
        #             print(f"index: {index}, len(lists): {len(lists)}")
        #             lists[index].append(data)
        #     else:
        #         lists.append(output[0])
        # else:
        #     lists.append(output)
    return hook

def getTwoActivationList(list0, list1):
    # the hook signature
    def hook(model, input, output):
        list0.append(output[0])
        list1.append(output[1])
        # if isinstance(output, tuple):
        #     print(f"len(output): {len(output)}")
        #     if len(output) > 1:
        #         for index, data in enumerate(output):
        #             print(f"index: {index}, len(lists): {len(lists)}")
        #             lists[index].append(data)
        #     else:
        #         lists.append(output[0])
        # else:
        #     lists.append(output)
    return hook
    
def get_max_numbered_filename(directory):
    filenames = os.listdir(directory)
    pattern = re.compile(r'\d+')
    numbers = [int(pattern.search(filename).group()) for filename in filenames if pattern.search(filename)]
    return max(numbers) if numbers else None

def cast_hook(unet,dicts):
    for i,net in enumerate(unet.transformer_blocks):
        net.attn.register_forward_hook(getActivation(dicts,str(i))) # net.attn ; net.norm2  net.ff (4096); norm2_context  ff_context (512/512)

    for i,net in enumerate(unet.single_transformer_blocks):
        net.attn.register_forward_hook(getActivation(dicts,str(i+19)))
		
def cast_hook_list(unet, lists):
    lists.append([])
    lists.append([])
    lists.append([])
    # print(f"len(lists): {len(lists)}")
    for i,net in enumerate(unet.transformer_blocks):
        net.attn.register_forward_hook(getTwoActivationList(lists[0], lists[1]))

    for i,net in enumerate(unet.single_transformer_blocks):
        net.attn.register_forward_hook(getActivationList(lists[2]))

def _prepare_latent_image_ids(batch_size, height, width, device, dtype):
    latent_image_ids = torch.zeros(height // 2, width // 2, 3)
    latent_image_ids[..., 1] = latent_image_ids[..., 1] + torch.arange(height // 2)[:, None]
    latent_image_ids[..., 2] = latent_image_ids[..., 2] + torch.arange(width // 2)[None, :]

    latent_image_id_height, latent_image_id_width, latent_image_id_channels = latent_image_ids.shape

    latent_image_ids = latent_image_ids.reshape(
        latent_image_id_height * latent_image_id_width, latent_image_id_channels
    )

    return latent_image_ids.to(device=device, dtype=dtype)

def _pack_latents(latents, batch_size, num_channels_latents, height, width):
    latents = latents.view(batch_size, num_channels_latents, height // 2, 2, width // 2, 2)
    latents = latents.permute(0, 2, 4, 1, 3, 5)
    latents = latents.reshape(batch_size, (height // 2) * (width // 2), num_channels_latents * 4)

    return latents

    
def deepspeed_zero_init_disabled_context_manager():
    """
    returns either a context list that includes one that will disable zero.Init or an empty context list
    """
    deepspeed_plugin = AcceleratorState().deepspeed_plugin if accelerate.state.is_initialized() else None
    if deepspeed_plugin is None:
        return []

    return [deepspeed_plugin.zero3_init_context_manager(enable=False)]

def calculate_shift(
    image_seq_len,
    base_seq_len: int = 256,
    max_seq_len: int = 4096,
    base_shift: float = 0.5,
    max_shift: float = 1.16,
):
    m = (max_shift - base_shift) / (max_seq_len - base_seq_len)
    b = base_shift - m * base_seq_len
    mu = image_seq_len * m + b
    return mu

def retrieve_timesteps(
    scheduler,
    num_inference_steps: Optional[int] = None,
    device: Optional[Union[str, torch.device]] = None,
    timesteps: Optional[List[int]] = None,
    sigmas: Optional[List[float]] = None,
    **kwargs,
):
    if timesteps is not None and sigmas is not None:
        raise ValueError("Only one of `timesteps` or `sigmas` can be passed. Please choose one to set custom values")
    if timesteps is not None:
        accepts_timesteps = "timesteps" in set(inspect.signature(scheduler.set_timesteps).parameters.keys())
        if not accepts_timesteps:
            raise ValueError(
                f"The current scheduler class {scheduler.__class__}'s `set_timesteps` does not support custom"
                f" timestep schedules. Please check whether you are using the correct scheduler."
            )
        scheduler.set_timesteps(timesteps=timesteps, device=device, **kwargs)
        timesteps = scheduler.timesteps
        num_inference_steps = len(timesteps)
    elif sigmas is not None:
        accept_sigmas = "sigmas" in set(inspect.signature(scheduler.set_timesteps).parameters.keys())
        if not accept_sigmas:
            raise ValueError(
                f"The current scheduler class {scheduler.__class__}'s `set_timesteps` does not support custom"
                f" sigmas schedules. Please check whether you are using the correct scheduler."
            )
        scheduler.set_timesteps(sigmas=sigmas, device=device, **kwargs)
        timesteps = scheduler.timesteps
        num_inference_steps = len(timesteps)
    else:
        scheduler.set_timesteps(num_inference_steps, device=device, **kwargs)
        timesteps = scheduler.timesteps
    return timesteps, num_inference_steps




class InferPreprocess(Preprocess):

    def __init__(self, infer_pg, is_infer_rank, batch_size, infer_rank):
        self.infer_pg = infer_pg
        self.is_infer_rank = is_infer_rank
        self.bsz_org = batch_size
        self.infer_rank = infer_rank

    def has_gpu_preprocess(self):
        return True
    
    def gpu_preprocess(self, batch, stream):
        train_device = "cuda"
        weight_dtype = torch.bfloat16

        # pixel_values = batch["pixel_values"].to(device=train_device)
        input_ids_t5_en = batch["input_ids_t5_en"].to(device=train_device)
        input_ids_en = batch["input_ids_en"].to(device=train_device)
        input_ids_t5 = batch["input_ids_t5"].to(device=train_device)
        attention_mask = batch["attention_mask"].to(device=train_device)
        # image_grid_thw = batch["image_grid_thw"].to(device=train_device)

        # 将训练卡的batch数据发送到推理卡上
        # print(f"input_ids_t5_en: {input_ids_t5_en.shape}")
        # print(f"input_ids_en: {input_ids_en.shape}")
        # print(f"input_ids_t5: {input_ids_t5.shape}, input_ids_t5.dtype: {input_ids_t5.dtype}")
        # print(f"attention_mask: {attention_mask.shape}, attention_mask.dtype: {attention_mask.dtype}")
        torch.cuda.synchronize()
        tai.send_to_infer_device(input_ids_t5_en, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish input_ids_t5_en")
        tai.send_to_infer_device(input_ids_en, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish input_ids_en")
        tai.send_to_infer_device(input_ids_t5, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish input_ids_t5")
        tai.send_to_infer_device(attention_mask, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish attention_mask")
        # tai.send_to_infer_device(pixel_values, self.infer_pg, self.is_infer_rank, self.infer_rank)
        # tai.send_to_infer_device(image_grid_thw, self.infer_pg, self.is_infer_rank, self.infer_rank)

        KD_teacher_tensor0 = torch.zeros((self.bsz_org, 19, 4096, 3072), dtype=weight_dtype, device=train_device)
        KD_teacher_tensor1 = torch.zeros((self.bsz_org, 19, 512, 3072), dtype=weight_dtype, device=train_device)
        KD_teacher_tensor2 = torch.zeros((self.bsz_org, 38, 4608, 3072), dtype=weight_dtype, device=train_device)
        
        latents = torch.zeros((self.bsz_org, 4096, 64), dtype=weight_dtype, device=train_device)
        text_embeddings = torch.zeros((self.bsz_org, 29, 512, 3584),dtype=weight_dtype,  device=train_device)
        timestep = torch.zeros((self.bsz_org), dtype=torch.bfloat16,  device=train_device)
        torch.cuda.synchronize()

        # 从推理卡获取推理结果
        KD_teacher_tensor0 = tai.receive_from_infer_device(KD_teacher_tensor0, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish KD_teacher_tensor0")
        KD_teacher_tensor1 = tai.receive_from_infer_device(KD_teacher_tensor1, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish KD_teacher_tensor1")
        KD_teacher_tensor2 = tai.receive_from_infer_device(KD_teacher_tensor2, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish KD_teacher_tensor2")
        latents = tai.receive_from_infer_device(latents, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish latents")
        text_embeddings = tai.receive_from_infer_device(text_embeddings, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish text_embeddings")
        timestep = tai.receive_from_infer_device(timestep, self.infer_pg, self.is_infer_rank, self.infer_rank)
        torch.cuda.synchronize()
        # print(f"xxxxxx finish timestep")
        batch["KD_teacher_tensor0"] = KD_teacher_tensor0
        batch["KD_teacher_tensor1"] = KD_teacher_tensor1
        batch["KD_teacher_tensor2"] = KD_teacher_tensor2
        batch["latents"] = latents
        batch["text_embeddings"] = text_embeddings
        batch["timestep"] = timestep

        return batch

def train(args, infer_pg, is_infer_rank, train_pg, group_rank, infer_rank,teacher,paths):
    train_device = torch.device("cuda")
    weight_dtype = torch.bfloat16
    logging_dir = Path(args.output_dir, args.logging_dir)
    is_main_process = dist.get_rank(train_pg) == 0
    is_local_main_process = is_main_process

    rank = dist.get_rank()

    logging.basicConfig(
        format="%(asctime)s - %(levelname)s - %(name)s - %(message)s",
        datefmt="%m/%d/%Y %H:%M:%S",
        level=logging.INFO,
    )
    if is_main_process:
        datasets.utils.logging.set_verbosity_warning()
        transformers.utils.logging.set_verbosity_warning()
        diffusers.utils.logging.set_verbosity_info()
    else:
        datasets.utils.logging.set_verbosity_error()
        transformers.utils.logging.set_verbosity_error()
        diffusers.utils.logging.set_verbosity_error()

    # Handle the repository creation
    if is_main_process:
        if args.output_dir is not None:
            os.makedirs(args.output_dir, exist_ok=True)
    
    # print(f"rank: {rank}, will load scheduler")
    scheduler = FlowMatchEulerDiscreteScheduler.from_pretrained(teacher, subfolder="scheduler")
    noise_scheduler_copy = copy.deepcopy(scheduler)
    torch.cuda.synchronize()

    tokenizer_t5 = AutoProcessor.from_pretrained(paths, trust_remote_code=True)
    # proj_t5 = Proj3(in_channels=25, kernel_size=5, input_dim=896, output_dim0=768, output_dim1=4096, num_layers=4, num_heads=12, layer_norm_eps=1e-6, head_dim=64).to(dtype=weight_dtype)
    # proj_t5 = Proj(in_channels=2, kernel_size=5, input_dim=896, output_dim0=768, output_dim1=4096, num_layers=4, num_heads=12, layer_norm_eps=1e-6).to(dtype=weight_dtype)
    # proj_t5 = Proj4(in_channels=29, hidden_channels=18, kernel_size=5, input_dim=3584, hidden_dim=1024, output_dim0=768, output_dim1=4096, num_layers=4, num_heads=16, norm_eps=1e-6, head_dim=64).to(dtype=weight_dtype)
    # proj_t5 = Proj4(in_channels=29, hidden_channels=10, kernel_size=5, input_dim=3584, hidden_dim=3584, output_dim0=768, output_dim1=4096, num_layers=2, num_heads=16, norm_eps=1e-6, head_dim=64).to(dtype=weight_dtype)
    # proj_t5 = Proj7(in_channels=29, kernel_size=5, input_dim=3584, output_dim0=768, output_dim1=4096, num_layers=2, \
    #     num_heads=28, norm_eps=1e-6, head_dim=128).to(dtype=weight_dtype)

    proj_t5 = create_proj3(in_channels=29, use_t5=False, use_scale=False, use_cnn=True).to(dtype=weight_dtype)

    # Get the most recent checkpoint
    last_checkpoint_step = get_max_numbered_filename(args.output_dir)
    if last_checkpoint_step is not None:
        proj_t5_checkpoint_path = os.path.join(args.output_dir, str(last_checkpoint_step), "diffusion_pytorch_model.bin")
        state_dict = torch.load(proj_t5_checkpoint_path, map_location="cpu")
        proj_t5.load_state_dict(state_dict)
        print(f"xxxxxx load last_checkpoint_step: {last_checkpoint_step}, proj_t5_checkpoint_path: {proj_t5_checkpoint_path}")
    proj_t5.to(dtype=weight_dtype)

    tokenizer = CLIPTokenizer.from_pretrained(teacher, subfolder="tokenizer", revision="refs/pr/1")
    tokenizer_2 = T5TokenizerFast.from_pretrained(teacher, subfolder="tokenizer_2", revision="refs/pr/1")

    # with ContextManagers(deepspeed_zero_init_disabled_context_manager()):
    #     print(f"rank: {rank}, will load flux")
    #     transformer = FluxTransformer2DModel.from_pretrained(teacher, subfolder="transformer")
    torch.cuda.synchronize()
    # print(f"rank: {rank}, will load flux transformer")
    transformer = FluxTransformer2DModel.from_pretrained(teacher, subfolder="transformer")
    torch.cuda.synchronize()
    # print(f"rank: {rank}, train finish load model")

    transformer.eval()
    transformer.requires_grad_(False)
    proj_t5.train()

    torch.cuda.synchronize()

    # print(f"rank: {rank}, train finish set model")

    
    transformer.to(train_device, dtype=weight_dtype)
    proj_t5.to(train_device)

    # proj_t5.enable_gradient_checkpointing()
    # print("#######################")
    
    KD_student= []
    cast_hook_list(transformer,KD_student)

    # Use 8-bit Adam for lower memory usage or to fine-tune the model in 16GB GPUs
    if args.use_8bit_adam:
        try:
            import bitsandbytes as bnb
        except ImportError:
            raise ImportError(
                "To use 8-bit Adam, please install the bitsandbytes library: `pip install bitsandbytes`."
            )

        optimizer_class = bnb.optim.AdamW8bit
    else:
        optimizer_class = torch.optim.AdamW

    total = sum(p.numel() for p in proj_t5.parameters())
    print("**********paras***********",total) 

    # Optimizer creation
    optimizer = optimizer_class(
        proj_t5.parameters(),
        lr=args.learning_rate,
        betas=(args.adam_beta1, args.adam_beta2),
        weight_decay=args.adam_weight_decay,
        eps=args.adam_epsilon,
    )

    print(f"rank: {rank}, train finish init optimizer")

    preprocess = InferPreprocess(infer_pg, is_infer_rank, args.batch_size, infer_rank)

    datamodule = DataModuleCustom(args, tokenizer_t5=tokenizer_t5, tokenizer_t5_en=tokenizer_2, tokenizer_en=tokenizer)
    train_dataloader = datamodule._train_dataloader(preprocess=preprocess, process_group=train_pg, group_rank=group_rank)

    # print(f"train finish init train_dataloader")


    # len_train_dataloader = len(datamodule.datasets['train'])//datamodule.batch_size # len(train_dataloader)

    # Scheduler and math around the number of training steps.
    overrode_max_train_steps = False
    num_update_steps_per_epoch = 10e10
    if args.max_train_steps is None:
        args.max_train_steps = args.num_train_epochs * num_update_steps_per_epoch
        overrode_max_train_steps = True

    lr_scheduler = get_scheduler(
        args.lr_scheduler,
        optimizer=optimizer,
        num_warmup_steps=args.lr_warmup_steps * args.gradient_accumulation_steps,
        num_training_steps=args.max_train_steps * args.gradient_accumulation_steps,
    )
    print(f"train finish init lr_scheduler")
    proj_t5 = DistributedDataParallel(proj_t5, process_group=train_pg, find_unused_parameters=True)
    print(f"train finish accelerator.prepare")
    # transformer, optimizer1,train_dataloader = accelerator1.prepare(
    #  transformer, optimizer1,train_dataloader
    # )

    # We need to recalculate our total training steps as the size of the training dataloader may have changed.
    # num_update_steps_per_epoch = math.ceil(len_train_dataloader / args.gradient_accumulation_steps)
    if overrode_max_train_steps:
        args.max_train_steps = args.num_train_epochs * num_update_steps_per_epoch
    # Afterwards we recalculate our number of training epochs
    args.num_train_epochs = math.ceil(args.max_train_steps / num_update_steps_per_epoch)

    # We need to initialize the trackers we use, and also store our configuration.
    # The trackers initializes automatically on the main process.

    # if accelerator.is_main_process:
    #     accelerator.init_trackers("text2image-fine-tune-sdxl", config=vars(args))

    ############## Train!
    total_batch_size = args.batch_size * dist.get_world_size(train_pg) * args.gradient_accumulation_steps
    if is_main_process:
        print("***** Running training *****")
        print(f"  Num Epochs = {args.num_train_epochs}")
        print(f"  Instantaneous batch size per device = {args.batch_size}")
        print(f"  Total train batch size (w. parallel, distributed & accumulation) =   {total_batch_size}")
        print(f"  Gradient Accumulation steps = {args.gradient_accumulation_steps}")
        print(f"  Total optimization steps = {args.max_train_steps}")
    global_step = 0
    first_epoch = 0

    # Potentially load in the weights and states from a previous save
    if args.resume_from_checkpoint:
        if args.resume_from_checkpoint != "latest":
            path = os.path.basename(args.resume_from_checkpoint)
        else:
            # Get the most recent checkpoint
            dirs = os.listdir(args.output_dir)
            dirs = [d for d in dirs if d.startswith("checkpoint")]
            dirs = sorted(dirs, key=lambda x: int(x.split("-")[1]))
            path = dirs[-1] if len(dirs) > 0 else None

        if path is None:
            print(
                f"Checkpoint '{args.resume_from_checkpoint}' does not exist. Starting a new training run."
            )
            args.resume_from_checkpoint = None
            initial_global_step = 0
        else:
            print(f"Resuming from checkpoint {path}")
            accelerator.load_state(os.path.join(args.output_dir, path))
            global_step = int(path.split("-")[1])

            initial_global_step = global_step
            first_epoch = global_step // num_update_steps_per_epoch

    else:
        initial_global_step = 0

    # last checkpoint step
    if last_checkpoint_step is not None:
        global_step = last_checkpoint_step
        initial_global_step = last_checkpoint_step

    progress_bar = tqdm(
        range(0, args.max_train_steps),
        initial=initial_global_step,
        desc="Steps",
        # Only show the progress bar once on each machine.
        disable=not is_local_main_process,
    )


    # torch.distributed.distributed_c10d.GroupMember.WORLD = default_pg

    bsz_org = args.batch_size
    # bsz = (dist.get_world_size(infer_pg) - 1) * bsz_org
    height = 128
    width = 128
    seq_len = 512
    seq_len_1 = 77
    text_ids = torch.zeros(seq_len, 3).to(device=train_device, dtype=weight_dtype)
    latent_image_ids = _prepare_latent_image_ids(bsz_org, height, width, train_device, weight_dtype)
    guidance = torch.tensor([3.5], device=train_device, dtype=weight_dtype)
    guidance = guidance.expand(bsz_org)

    for epoch in range(first_epoch, args.num_train_epochs):
        # for step, batch in enumerate(train_dataloader):
        #     # print(f"step: {step}, batch: {batch.keys()}")
        #     continue
        train_loss = 0.0
        for step, batch in enumerate(train_dataloader):
            # print("########### step ###########", step)
            # with accelerator.accumulate(proj_t5):
            sync_gradients = step % args.gradient_accumulation_steps == 0

            # pixel_values = batch["pixel_values"].to(device=train_device,dtype=weight_dtype)
            input_ids_t5_en = batch["input_ids_t5_en"].to(device=train_device)
            input_ids_en = batch["input_ids_en"].to(device=train_device)
            input_ids_t5 = batch["input_ids_t5"].to(device=train_device)

            KD_teacher_tensor0 = batch["KD_teacher_tensor0"].to(device=train_device)
            KD_teacher_tensor1 = batch["KD_teacher_tensor1"].to(device=train_device)
            KD_teacher_tensor2 = batch["KD_teacher_tensor2"].to(device=train_device)

            latents = batch["latents"].to(device=train_device)
            text_embeddings = batch["text_embeddings"].to(device=train_device)
            timestep = batch["timestep"].to(device=train_device)

            add_text_embeds, prompt_embeds_zh = proj_t5(text_embeddings)

            # timestep = timesteps[0].expand(batch_size).to(device=train_device, dtype=transformer.dtype)
            noise_pred = transformer(
                hidden_states=latents.to(train_device),
                timestep=timestep / 1000,
                txt_ids=text_ids.to(train_device),
                guidance=guidance,
                img_ids=latent_image_ids.to(train_device),
                encoder_hidden_states=prompt_embeds_zh.to(device=train_device, dtype=transformer.dtype),  # b*512*4096
                pooled_projections=add_text_embeds.to(device=train_device, dtype=transformer.dtype), # b*768
                return_dict=False,
            )[0]


            KD_student_tensor0 = torch.stack(KD_student[0], dim=1).to(train_device)
            KD_student_tensor1 = torch.stack(KD_student[1], dim=1).to(train_device)
            KD_student_tensor2 = torch.stack(KD_student[2], dim=1).to(train_device)
            KD_student[0].clear()
            KD_student[1].clear()
            KD_student[2].clear()
            # KD_student.clear()

            # loss  = F.mse_loss(KD_teacher_tensor0, KD_student_tensor0, reduction="none").mean([0, 2, 3]).sum()
            # loss += F.mse_loss(KD_teacher_tensor1, KD_student_tensor1, reduction="none").mean([0, 2, 3]).sum()
            # loss += F.mse_loss(KD_teacher_tensor2, KD_student_tensor2, reduction="none").mean([0, 2, 3]).sum()
            loss = 0
            temperature0 = 3
            for i in range(19):
                down_feature = F.kl_div(F.softmax(normalize(KD_teacher_tensor0[:,i])/temperature0, dim=-1).log(), F.softmax(normalize(KD_student_tensor0[:,i])/temperature0, dim=-1), reduction='batchmean')
                # down_feature = F.kl_div(F.softmax(KD_student_tensor0[:,i]/temperature0, dim=-1).log(), F.softmax(KD_teacher_tensor0[:,i]/temperature0, dim=-1), reduction='batchmean')
                if not (torch.isinf(down_feature).any() or torch.isnan(down_feature).any()):
                    loss=loss+down_feature
                else:
                    print(f"down_feature:{i}")
                down_feature1 = F.kl_div(F.softmax(normalize(KD_teacher_tensor1[:,i])/temperature0, dim=-1).log(), F.softmax(normalize(KD_student_tensor1[:,i])/temperature0, dim=-1), reduction='batchmean')
                if not (torch.isinf(down_feature1).any() or torch.isnan(down_feature1).any()):
                    loss=loss+down_feature1
                else:
                    print(f"down_feature1:{i}")
            for i in range(38):
                down_feature2 = F.kl_div(F.softmax(normalize(KD_teacher_tensor2[:,i])/temperature0, dim=-1).log(), F.softmax(normalize(KD_student_tensor2[:,i])/temperature0, dim=-1), reduction='batchmean')
                if not (torch.isinf(down_feature2).any() or torch.isnan(down_feature2).any()):
                    loss=loss+down_feature2
                else:
                    print(f"down_feature2:{i}")         

            train_loss = loss

            # Backpropagate
            loss.backward()
            if sync_gradients:
                params_to_clip = proj_t5.parameters()
                torch.nn.utils.clip_grad_norm_(params_to_clip, args.max_grad_norm)
                
                optimizer.step()
                lr_scheduler.step()
                optimizer.zero_grad()

            # Checks if the accelerator has performed an optimization step behind the scenes 检查梯度当前是否在所有进程之间同步
            if sync_gradients:

                progress_bar.update(1)
                global_step += 1
                # accelerator.log({"train_loss": train_loss}, step=global_step)
                train_loss = 0.0

                if is_main_process:
                    if global_step % args.checkpointing_steps == 0:
                        print(f"#########{args.checkpointing_steps} saving model #######")
                        save_path = os.path.join(args.output_dir, f"{global_step}")
                        state_dict = proj_t5.module.state_dict()
                        os.makedirs(save_path, exist_ok=True)
                        torch.save(state_dict, os.path.join(save_path, "diffusion_pytorch_model.bin"))


            logs = {"step_loss": loss.detach().item(), "lr": lr_scheduler.get_last_lr()[0]}
            progress_bar.set_postfix(**logs)

            if global_step >= args.max_train_steps:
                break
        

    # accelerator.wait_for_everyone()
    # accelerator.end_training()

def infer(args, infer_pg, is_infer_rank, infer_rank,teacher,paths):
    weight_dtype = torch.bfloat16
    infer_device = torch.device("cuda")

    text_encoder_t5 = AutoModel.from_pretrained(
            paths,
            trust_remote_code=True,
            attn_implementation='sdpa', # sdpa or flash_attention_2
            torch_dtype=torch.bfloat16,
            init_vision=True,
            init_audio=True,
            init_tts=True
        )

    text_encoder = CLIPTextModel.from_pretrained(teacher, revision="refs/pr/1",subfolder="text_encoder", torch_dtype=torch.bfloat16)
    text_encoder_2 = T5EncoderModel.from_pretrained(teacher, revision="refs/p1", subfolder="text_encoder_2", torch_dtype=torch.bfloat16)
    transformer_t = FluxTransformer2DModel.from_pretrained(teacher, subfolder="transformer")
    tokenizer_1 = AutoTokenizer.from_pretrained(paths, trust_remote_code=True)

    # vae.eval()
    # vae.requires_grad_(False)
    text_encoder_t5.eval()
    text_encoder_t5.requires_grad_(False)

    transformer_t.train()
    transformer_t.requires_grad_(False)
    text_encoder.eval()
    text_encoder.requires_grad_(False)
    text_encoder_2.eval()
    text_encoder_2.requires_grad_(False)

    text_encoder.to(infer_device, dtype=weight_dtype)
    text_encoder_2.to(infer_device, dtype=weight_dtype)
    text_encoder_t5.to(infer_device, dtype=weight_dtype)

    transformer_t.to(infer_device, dtype=weight_dtype)
    # vae.to(infer_device, dtype=weight_dtype)

    KD_teacher = []
    cast_hook_list(transformer_t, KD_teacher)

    height = 128
    width = 128
    seq_len = 512
    seq_len_1 = 77
    bsz_org = args.batch_size
    bsz = (dist.get_world_size(infer_pg) - 1) * bsz_org

    print(f"infer bsz_org: {bsz_org}, bsz: {bsz}")

    text_ids = torch.zeros(seq_len, 3).to(device=infer_device, dtype=weight_dtype)
    latent_image_ids = _prepare_latent_image_ids(bsz, height, width, infer_device, weight_dtype)

    input_ids_t5_en_ = torch.empty(size=(bsz_org, seq_len), dtype=torch.long, device=infer_device)
    input_ids_en_ = torch.empty(size=(bsz_org, seq_len_1), dtype=torch.long, device=infer_device)
    input_ids_t5_ = torch.empty(size=(bsz_org, seq_len), dtype=torch.int32, device=infer_device)
    attention_mask_ = torch.empty(size=(bsz_org, seq_len), dtype=torch.bool, device=infer_device)
    # pixel_values_ = torch.empty(size=(bsz_org, 1296, 1176), dtype=torch.float32, device=infer_device)
    # image_grid_thw_ = torch.empty(size=(bsz_org, 3), dtype=torch.long, device=infer_device)

    scheduler = FlowMatchEulerDiscreteScheduler.from_pretrained(teacher,  subfolder="scheduler")
    guidance = torch.tensor([3.5], device=infer_device, dtype=weight_dtype)
    guidance = guidance.expand(bsz_org)
    print(f"infer finish load model, will get data by nccl")

    step = 0

    while True:
        with torch.no_grad():
            try:
                torch.cuda.synchronize()
                # print(f"infer begin send_to_infer_device")
                input_ids_t5_en = tai.send_to_infer_device(input_ids_t5_en_, infer_pg, is_infer_rank, infer_rank)
                torch.cuda.synchronize()
                # print(f"infer finish get input_ids_t5_en")
                input_ids_en = tai.send_to_infer_device(input_ids_en_, infer_pg, is_infer_rank, infer_rank)
                torch.cuda.synchronize()
                # print(f"infer finish get input_ids_en")
                input_ids_t5 = tai.send_to_infer_device(input_ids_t5_, infer_pg, is_infer_rank, infer_rank)
                torch.cuda.synchronize()
                # print(f"infer finish get input_ids_t5")
                attention_mask = tai.send_to_infer_device(attention_mask_, infer_pg, is_infer_rank, infer_rank)
                torch.cuda.synchronize()
                # print(f"infer finish get attention_mask")
                # pixel_values = tai.send_to_infer_device(pixel_values_, infer_pg, is_infer_rank, infer_rank)
                # image_grid_thw = tai.send_to_infer_device(image_grid_thw_, infer_pg, is_infer_rank, infer_rank)

            except Exception as e:
                print(f"****** Error: infer_pg: {dist.get_process_group_ranks(infer_pg)}, is_infer_rank: {is_infer_rank}, infer_rank: {infer_rank}")
                time.sleep(30)
                raise e

            # # TODO
            # input_dict = torch.load("./input_dict.pt")
            # input_ids_en = input_dict["input_ids_en"].to(device=infer_device)
            # input_ids_t5 = input_dict["input_ids_t5"].to(device=infer_device)
            # input_ids_t5_en = input_dict["input_ids_t5_en"].to(device=infer_device)

            prompts = [input_ids_t5_en, input_ids_en]
            batch_size = len(input_ids_t5)
            height = 128
            width = 128
            num_channels_latents = transformer_t.config.in_channels // 4
            shape = (batch_size, num_channels_latents, height, width)
            generator = torch.Generator(device=infer_device).manual_seed(step)
            latents = randn_tensor(shape, generator=generator, device=infer_device, dtype=weight_dtype) # b*16*128*128
            latents = _pack_latents(latents, batch_size, num_channels_latents, height, width)
            latent_image_ids = _prepare_latent_image_ids(batch_size, height, width, infer_device, weight_dtype)

            # Prepare timesteps
            num_inference_steps = 1
            sigmas = np.linspace(1.0, 1 / num_inference_steps, num_inference_steps)
            image_seq_len = latents.shape[1]
            # print(f"base_image_seq_len: {scheduler.config.base_image_seq_len}, max_image_seq_len: {scheduler.config.max_image_seq_len}")
            mu = calculate_shift(
                image_seq_len,
                scheduler.config.base_image_seq_len,
                scheduler.config.max_image_seq_len,
                scheduler.config.base_shift,
                scheduler.config.max_shift,
            )
            timesteps, num_inference_steps = retrieve_timesteps(
                scheduler,
                num_inference_steps,
                infer_device,
                None,
                sigmas,
                mu=mu,
            )

            inputs={"input_ids":input_ids_t5.to(infer_device),"attention_mask":attention_mask.to(infer_device),"pixel_values":[[]]*len(input_ids_t5)}
            output_hidden_state_all= text_encoder_t5.generate(**inputs,\
                tokenizer=tokenizer_1,max_new_tokens=2048,decode_text=False).hidden_states

            text_embeddings = torch.stack(output_hidden_state_all, dim=1)
            # print(f"text_embeddings: {text_embeddings.shape}")
            prompt_embeds_en = text_encoder_2(prompts[0].to(infer_device), output_hidden_states=False)[0]
            add_text_embeds_en = text_encoder(prompts[1].to(infer_device), output_hidden_states=False).pooler_output
            text_ids = torch.zeros(prompt_embeds_en.shape[1], 3).to(device=infer_device, dtype=weight_dtype)
            timestep = timesteps[0].expand(batch_size).to(device=infer_device, dtype=weight_dtype)
            # print(f"text_embeddings: {text_embeddings.shape}, prompt_embeds_en: {prompt_embeds_en.shape}, add_text_embeds_en: {add_text_embeds_en.shape}"
            # print(f"infer finish init timestep")
            noise_pred_teacher = transformer_t(
                hidden_states=latents,
                timestep=timestep / 1000,
                txt_ids=text_ids,
                guidance=guidance,
                img_ids=latent_image_ids,
                encoder_hidden_states=prompt_embeds_en, 
                pooled_projections=add_text_embeds_en, # 
                return_dict=False,
            )[0]
            # print(f"infer finish transformer_t")

            KD_teacher_tensor0 = torch.stack(KD_teacher[0], dim=1).to(infer_device)
            KD_teacher_tensor1 = torch.stack(KD_teacher[1], dim=1).to(infer_device)
            KD_teacher_tensor2 = torch.stack(KD_teacher[2], dim=1).to(infer_device)
            # print(f"KD_teacher_tensor0.shape: {KD_teacher_tensor0.shape}")
            # print(f"KD_teacher_tensor1.shape: {KD_teacher_tensor1.shape}")
            # print(f"KD_teacher_tensor2.shape: {KD_teacher_tensor2.shape}")
            KD_teacher[0].clear()
            KD_teacher[1].clear()
            KD_teacher[2].clear()
            # print(f"KD_teacher_tensor0: {KD_teacher_tensor0.shape}")
            # print(f"KD_teacher_tensor1: {KD_teacher_tensor1.shape}")
            # print(f"KD_teacher_tensor2: {KD_teacher_tensor2.shape}")
            # print(f"latents: {latents.shape}")
            # print(f"text_embeddings: {text_embeddings.shape}")
            # print(f"timestep: {timestep.shape}")
            torch.cuda.synchronize()
            # 将推理结果发送给训练卡
            tai.receive_from_infer_device(KD_teacher_tensor0, infer_pg, is_infer_rank, infer_rank)
            torch.cuda.synchronize()
            # print(f"xxxxxx finish receive_from_infer_device KD_teacher_tensor0, ")
            tai.receive_from_infer_device(KD_teacher_tensor1, infer_pg, is_infer_rank, infer_rank)
            torch.cuda.synchronize()
            # print(f"xxxxxx finish receive_from_infer_device KD_teacher_tensor1")
            tai.receive_from_infer_device(KD_teacher_tensor2, infer_pg, is_infer_rank, infer_rank)
            torch.cuda.synchronize()
            # print(f"xxxxxx finish receive_from_infer_device KD_teacher_tensor2")
            tai.receive_from_infer_device(latents, infer_pg, is_infer_rank, infer_rank)
            torch.cuda.synchronize()
            # print(f"xxxxxx finish receive_from_infer_device latents")
            tai.receive_from_infer_device(text_embeddings, infer_pg, is_infer_rank, infer_rank)
            torch.cuda.synchronize()
            # print(f"xxxxxx finish receive_from_infer_device text_embeddings")
            tai.receive_from_infer_device(timestep, infer_pg, is_infer_rank, infer_rank)
            torch.cuda.synchronize()
            # print(f"xxxxxx finish receive_from_infer_device timestep")
            step += 1




def seed_torch(seed=2024):
    random.seed(seed)  
    os.environ['PYTHONHASHSEED'] = str(seed)    
    np.random.seed(seed)  
    torch.manual_seed(seed)  
    torch.cuda.manual_seed(seed)   
    torch.cuda.manual_seed_all(seed)  
    torch.backends.cudnn.benchmark = False   
    torch.backends.cudnn.deterministic = True  

def main(args):

    # local_rank = int(os.environ["LOCAL_RANK"])
    # rank = int(os.environ["RANK"])
    

    local_infer_world_size = 2
    local_rank, local_world_size, rank, world_size, group_rank, group_world_size = tai.dist_info1()


    torch.distributed.init_process_group(backend="nccl")
    torch.cuda.set_device(local_rank)
    # torch.set_default_device(f'cuda:{local_rank}')

    seed_torch(seed=rank*2024)

   
    infer_pg, infer_rank, is_infer_rank, infer_pg_world_size, infer_pgs = tai.new_infer_pg(rank, local_infer_world_size, local_world_size, world_size)
    train_pg, _ = tai.new_train_pg(rank, local_infer_world_size, local_world_size, world_size)
    _ZERO_PARAM_INTRA_PARALLEL_GROUP = train_pg
    _DATA_PARALLEL_GROUP = train_pg

    teacher = "/mnt/data/group/models/flux/FLUX.1-dev"
    paths = "/mnt/data/group/models/flux/MiniCPM-o-2_6"

    if is_infer_rank:

        infer(args, infer_pg, is_infer_rank, infer_rank,teacher,paths)
    else:
        train(args, infer_pg, is_infer_rank, train_pg, group_rank, infer_rank,teacher,paths)


if __name__ == "__main__":
    args = parse_args()
    main(args)