# 1. Environment Setup

Create and activate a new Conda environment with Python 3.11:

```bash
conda create -n cav-sam python=3.11
conda activate cav-sam
```

Install the necessary packages using `pip`:

```bash
pip install -r requirements.txt
```

Download the checkpoint of SAM2:

```bash
wget https://dl.fbaipublicfiles.com/segment_anything_2/072824/sam2_hiera_tiny.pt -O checkpoints/sam2_hiera_tiny.pt
```

# 2. Training LoRA

Execute the following command to start the LoRA training process on both the reference image and the target image:

```bash
python train_lora.py \
	--image-path "/path/to/your/image" \
	--lora-save-path "/path/to/save/lora" \
	--class-name "the_class_name_of_the_image"
```

The class name for different datasets:
- Chest X-Ray: chest X-ray
- Deepglobe: satellite image
- FSS-1000: seagull
- ISIC: dermoscopic lesion

# 3. Run Evaluation

After obtaining the trained LoRA weight files for the reference and target images, execute the following command to evaluate CAV-SAM:

```bash
python cav_sam.py 
    --reference-image-path "/path/to/your/reference/image" \
    --reference-mask-path "/path/to/your/reference/mask" \
    --target-image-path "/path/to/your/target/image" \
    --reference-lora-path "/path/to/save/reference/lora" \
    --target-lora-path "/path/to/save/target/lora" \
    --pred-save-path "/path/to/save/predictions" \
    --class-name "the_class_name_of_the_image"
```