# Learn about Configs

## Use Pre-Trained Model

To use the pre-trained model for the whole network, the config adds the link of pre-trained models in the
`pretrain`. We set `pretrain=None` by default and use the CLIP model as the pre-trained model.

```
pretrain:/home/user/Data/SAMPLE_DATA/SAMPLE/full_supervised/ViT-B/16/HARDVS/HARDVS_train_full_supervised/model_best_HARDVS.pt
```

To resume the interrupted model, the config adds the link `resume`. You are able to resume your training started from the last saved model.

```
resume: /home/user/Data/SAMPLE_DATA/SAMPLE/full_supervised/ViT-B/16/HARDVS/HARDVS_train_full_supervised/last_model_HARDVS.pt
```

## Modify Dataset

The users may need to adapt one of the above dataset to fit for their special datasets.

```
#dataset settings
data:
    dataset: hmdb                                                 #dataset names
    num_classes: 51                                               #dataset classes
    image_tmpl: 'img_{:05d}.jpg'                                  #Picture naming format
    train_list: 'lists/hmdb51/train_rgb_split1.txt'               #dataset traning list  
    val_list: 'lists/hmdb51/val_rgb_split1.txt'                   #dataset validation list
    label_list: 'lists/hmdb51_labels.csv'                         #dataset label list
```

## Modify Training Schedule

Finetuning usually requires smaller learning rate and less training epochs.

```
solver:
    # learning policy
    type: cosine       #cosine multistep
    epochs: 50
    start_epoch: 0
    epoch_offset: 0

    # optimizer 
    optim: adamw      #adam sgd adamw
    clip_gradient: 20
    loss_type: nll
    lr: 5.e-6
    lr_warmup_step: 5
    momentum: 0.9
    weight_decay: 0.0005
    lr_decay_step: 15
    lr_decay_factor: 0.1
```
