# Data Preparation

To prepare the datasets, we prefer to organize the dataset as follows:

- **Standard Folder** . Download [HARDVS](https://github.com/Event-AHU/HARDVS), [PAF,](https://github.com/CrystalMiaoshu/PAFBenchmark) [DVS128Gesture](https://research.ibm.com/publications/a-low-power-fully-event-based-gesture-recognition-system) and [SeAct](https://drive.google.com/file/d/1AO8KGzFT6784kiW2OzAgi0a-jqmzl-x6/view?usp=sharing) datasets. Prepare datasets by `<DATASET_NAME>_dataset.py`  into <DATASET_FOLDER> folder. The annotation files as `train.txt `and `val.txt`. Please make sure the folder looks like this:
  ```
  # datasets
  $ ls /PATH/TO/event| head -n 2
  a.aedat4
  b.aedat4

  # event preprocessing
  python dataset_prepare/<DATASET_NAME>_dataset.py

  # dataset_splits/[DATASET_NAME]/Zero-shot/train.txt
  # <DATASET_FOLDER>/<SQE_PATH> <FRAME_NUM> <class_id>
  $ head -n 2 /PATH/TO/train.txt
  a_folder 32 0
  b_folder 16 1

  # dataset_splits/[DATASET_NAME]/Zero-shot/test.txt
  $ head -n 2 /PATH/TO/val.txt
  c_folder 8 2
  d_folder 16 3
  ```

Note:

- We provide prepared annotation text files as `train.txt `and `val.txt` for all dataset in `dataset_splits` folder.
- The label files is provided in `lists` folder.
- Please refer to [ExACT&#39;s repository](https://github.com/jiazhou-garland/ExACT) for the files needed for event preprocessing in `<DATASET_NAME>_dataset.py`
- For base-to-novel setting, datasets are divided into base classes and novel classes. The model is trained on base classes for 16 samples of each categories and evaluated on novel classes and base class. The annotated txt files are  `dataset_splits/<DATASET_NAME>/base_to_novel/<DATASET_NAME>_base_train.txt`, `dataset_splits/<DATASET_NAME>/base_to_novel/<DATASET_NAME>_base_val.txt,` `dataset_splits/<DATASET_NAME>/base_to_novel/<DATASET_NAME>_novel.txt`
- For few-shot setting, The `dataset_splits/<DATASET_NAME>/few_shot/<DATASET_NAME>_few_shot_train_<x>.txt` file includes a `<x>` number of samples per class.

# Acknowledgement

The event prepocessing codes `<DATASET_NAME>_dataset.py` come from [ExACT](https://github.com/jiazhou-garland/ExACT)'s Adaptive Fine-grained Event (AFE) Preprocessing.
