# Getting Started

## Our code is implemented based on GaussianFormer and ISO.

## Installation

1. Create conda environment according to the following commands:
    ```
    $ conda create -n embodiedocc python=3.8 -y
    $ conda activate embodiedocc
    $ conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 -c pytorch -c nvidia
    $ cd EmbodiedOcc
    $ pip install -r requirements.txt
    ```

## Data Preparation

1. Download the Occ-ScanNet and our EmbodiedOcc-ScanNet(we will release this dataset soon).
2. Create a folder to store data at `/path/to/embodiedocc`
3. Store paths in environment variables for faster access:
    ```
    $ export DATA_PATH=/path/to/embodiedocc
    ```

## Train

1. Train local occupancy prediction module using 8 GPUs on Occ-ScanNet and Occ-ScanNet-mini2:
    ```
    $ cd EmbodiedOcc
    $ torchrun --nproc_per_node=8 train_mono.py
    ```
2. Train EmbodiedOcc using 8 GPUs on EmbodiedOcc-ScanNet and EmbodiedOcc-ScanNet-mini:
    ```
    $ cd EmbodiedOcc
    $ torchrun --nproc_per_node=8 train_embodied.py
    ```
