# -*- coding: utf-8 -*-

from .gso import GSODataset
from .gso_new import GSODataset as GSODatasetFixedView
from .objaverse import ObjaverseDataset
from .objaverse_new_render import ObjaverseDataset as ObjaverseDatasetFixed



def get_dataset(cfg, name):
    if cfg.data.category == "objaverse":
        return ObjaverseDataset(cfg, name)
    elif cfg.data.category == "objaverse_new":
        return ObjaverseDatasetFixed(cfg, name)
    elif cfg.data.category == "gso":
        return GSODataset(cfg, name)
    elif cfg.data.category == 'gso_new':
        return GSODatasetFixedView(cfg, name)
