#!/usr/bin/env bash
# ------------------------------------------------------------------------------------------------
# Deformable DETR
# Copyright (c) 2020 SenseTime. All Rights Reserved.
# Licensed under the Apache License, Version 2.0 [see LICENSE for details]
# ------------------------------------------------------------------------------------------------
# Modified from https://github.com/chengdazhi/Deformable-Convolution-V2-PyTorch/tree/pytorch_1.0.0
# ------------------------------------------------------------------------------------------------

# Copyright (c) Facebook, Inc. and its affiliates.
# Modified by Bowen Cheng from https://github.com/fundamentalvision/Deformable-DETR
#!/bin/bash
#SBATCH -J make              # Job name
#SBATCH -o run.txt        # output of standard out stream
#SBATCH -e run.txt         # output of err out stream
#SBATCH -p cvr                  # resource partion, candidates are: cvr, cvr-preem 
#SBATCH -N 1                    # requested num of Node
#SBATCH -n 1                    # requested num of CPU cores
#SBATCH --gres=gpu:hgx:1           # requested num of GPUs. 8 GPUs on each Node, 
#SBATCH --mem=30GB              # requested mem, otherwise OOM may occur
CUDA_HOME=/usr/local/cuda-11.3 python setup.py build install
