import os
import shutil

# 设置文件夹路径
source_folder = "./Pix2Pix_results/Pix2Pix_Distill_NJU2k_Depth_1024"  # 替换为你的文件夹路径
dataset_source = "../pixel2style2pixel-master/dataset/Distill_NJU2k_depth/source"
dataset_target = "../pixel2style2pixel-master/dataset/Distill_NJU2k_depth/target"

# 确保目标目录存在
os.makedirs(dataset_source, exist_ok=True)
os.makedirs(dataset_target, exist_ok=True)

# 遍历文件夹中的所有文件
for filename in os.listdir(source_folder):
    if filename.endswith(".jpg"):  # 确保是 jpg 文件
        file_path = os.path.join(source_folder, filename)
        
        # 判断文件名前缀并移动文件
        if filename.startswith("img_real_A_"):
            shutil.move(file_path, os.path.join(dataset_source, filename))
        elif filename.startswith("img_real_B_"):
            shutil.move(file_path, os.path.join(dataset_target, filename))

print("文件分类完成！")
