import cv2
import numpy as np
from skimage import img_as_ubyte

# 膨胀操作
def dilate_image(image, magnitude, iterations=1):
    # 使用指定大小的结构元素进行膨胀
    kernel_size = (magnitude, magnitude)
    kernel = np.ones(kernel_size, np.uint8)
    dilated_image = cv2.dilate(image, kernel, iterations=iterations)
    dilated_image = img_as_ubyte(dilated_image)
    return dilated_image

# 腐蚀操作
def erode_image(image, magnitude, iterations=1):
    # 使用指定大小的结构元素进行腐蚀
    kernel_size = (magnitude, magnitude)
    kernel = np.ones(kernel_size, np.uint8)
    eroded_image = cv2.erode(image, kernel, iterations=iterations)
    eroded_image = img_as_ubyte(eroded_image)
    return eroded_image

# 开运算：先腐蚀再膨胀
def opening_image(image, magnitude, iterations=1):
    # 先腐蚀再膨胀
    kernel_size = (magnitude, magnitude)
    kernel = np.ones(kernel_size, np.uint8)
    eroded_image = cv2.erode(image, kernel, iterations=iterations)
    opened_image = cv2.dilate(eroded_image, kernel, iterations=iterations)
    opened_image = img_as_ubyte(opened_image)
    return opened_image

# 闭运算：先膨胀再腐蚀
def closing_image(image, magnitude, iterations=1):
    # 先膨胀再腐蚀
    kernel_size = (magnitude, magnitude)
    kernel = np.ones(kernel_size, np.uint8)
    dilated_image = cv2.dilate(image, kernel, iterations=iterations)
    closed_image = cv2.erode(dilated_image, kernel, iterations=iterations)
    closed_image = img_as_ubyte(closed_image)
    return closed_image

# 读取图像并测试
if __name__ == "__main__":
    # 读取三通道彩色图像
    image_path = '100014.png'
    image = cv2.imread(image_path)  # 请替换为你的图像路径
    
    image = cv2.resize(image, (1024, 1024))
    # 执行各种形态学操作
    dilated = dilate_image(image, 5)
    eroded = erode_image(image, 5)
    opened = opening_image(image, 5)
    closed = closing_image(image, 5)

    # 显示结果
    cv2.imwrite('Dilated Image' + image_path, dilated)
    cv2.imwrite('Eroded Image' + image_path, eroded)
    cv2.imwrite('Opened Image' + image_path, opened)
    cv2.imwrite('Closed Image' + image_path, closed)

