STEERING_FILTER_PROMPT = """
[GUIDELINES]
You are an AI assistant tasked with assigning a label based on input text. You will be provided with two text paragraphs and a description of a visual feature.

The first paragraph is an original text generated by a model. The second paragraph is generated by a model with the visual feature clamped to a high value. Your goal is to determine the effect of clamping this feature on the generated output.

Label the effect as follows:

1 - No effect: The two paragraphs may have slight differences but convey the same overall meaning.
2 - Mention of the visual feature: Clamping this feature leads to an output that directly mentions the visual feature.
3 - Deep reasoning: Clamping this feature results in output that shows reasoning based on the visual feature. For example, if the visual feature is people eating, the output may refer to greed, reflecting an interpretive extension of the feature.
4 - Unrelated effect: Clamping this feature affects the generated output, but there is no clear connection between the visual feature and the differences between the paragraphs.

Please respond with only a single number: 1, 2, 3, or 4, and do not include any additional text.

Following are some examples:
[EXAMPLE_1]
Description : The bright spots on the dark background

Original : \nOnce upon a time, in a land far, far away, there lived two best friends named Alice and Bob. They had been inseparable since they were children, and they shared everything with each other. One day, while they were out exploring the woods, they stumbled upon a hidden path they had never seen before. Curious, they decided to follow it and see where it led.\n\nAs they walked, the path grew narrower and narrower until they found themselves in a clearing surrounded by towering trees. In the center of the clearing stood an old, gnarled tree, and on its trunk was a sign that read \"Welcome to the Land of Dreams.\"\n\nAlice and Bob looked at each other in amazement and wondered what the Land of Dreams was. They decided to explore further and soon found themselves in a beautiful meadow filled with wildflowers. They walked through the meadow, taking in the sights and sounds of nature, until they came to a small cottage.\n\nInside the cottage, they found a cozy room with a fireplace and a table covered in a white tablecloth. On the table was a plate of food and a pitcher of lemonade. Alice and Bob sat down and enjoyed their meal, feeling grateful for the unexpected adventure they had stumbled upon.\n\nAfter they finished eating, they decided to explore the rest of the Land of Dreams. They walked through fields of golden wheat, climbed mountains, and swam in crystal-clear lakes. They met all sorts of creatures, from friendly unicorns to mischievous fairies, and they had the time of their lives.\n\nAs the sun began to set, Alice and Bob made their way back to the clearing where they had first entered the Land of Dreams. They sat down on the grass and watched the stars come out one by one. They talked about all the amazing things they had seen and the memories they had made.\n\nAs they sat there, they realized that the Land of Dreams was not just a place, but a state of mind. It was a place where anything was possible, where imagination ran wild, and where friendship was the greatest treasure of all.\n\nAlice and Bob smiled at each other and knew that they would always cherish the memories of their adventure in the Land of Dreams. And as they drifted off to sleep, they dreamed of all the amazing things they would do together in the future.

Clamped : 尽我所能，以下是一个关于阿尔弗和鲜博的故事：\n\n阿尔弗和鲜博是两个年轻的朋友，他们住在同一个小镇上。他们经常一起玩耍，探索周围的森林和草原。有一天，他们发现了一条神秘的道路，走进去后发现它通往了一个神秘的森林。\n\n他们决定探索这个神秘的森林，并在路上遇到了许多奇怪的动物和植物。他们发现了一个神秘的宝石，据传说，这个宝石可以带来幸福和成功。阿尔弗和鲜博决定把宝石带回家，并在回家的路上遇到了一个神秘的魔法师。\n\n魔法师告诉他们，如果他们想要拥有这个宝石，他们必须完成一个挑战。他们必须在一天内完成一个艰难的任务，并在晚上返回。阿尔弗和鲜博决定接受这个挑战，并开始了他们的冒险。\n\n在一天内，他们完成了任务，并在晚上回到家。他们发现宝石已经变成了一个神秘的宝石，带来了一份无限的幸福和成功。从那天起，阿尔弗和鲜博成为了这个小镇的英雄，并在人们的记忆中留下了永恒的印记。

Answer : 4

[EXAMPLE_2]

Description : The tennis racket.

Original : <same with example 1>

Clamped :  once upon a time, in a land far, far away, there lived two young people named Alice and Bob. They were both very curious and loved to explore the world around them.\n\nOne day, while wandering through a dense forest, they stumbled upon a hidden path they had never seen before. Curious, they decided to follow it and see where it would lead them.\n\nThe path took them deeper into the forest, and they soon found themselves in a beautiful meadow filled with wildflowers. In the center of the meadow, there was a small cottage with a chimney from which smoke was rising.\n\nAlice and Bob approached the cottage and knocked on the door. An old woman answered, and she welcomed them into her home. She introduced herself as Granny, and she told them that she was a witch who lived in the forest.\n\nGranny told them that she had been watching them from afar and was impressed with their bravery and curiosity. She offered them a magical potion that would grant them one wish each.\n\nAlice and Bob were overjoyed and quickly made their wishes. Alice wished for the ability to fly, and Bob wished for the power to control the elements.\n\nGranny gave them the potion, and they drank it. Suddenly, they felt a strange sensation wash over them. When they looked up, they saw that Alice was flying through the air, and Bob was controlling the wind and rain.\n\nOverjoyed with their newfound powers, they thanked Granny and set off on their journey back home. But as they walked, they realized that their powers were not just for fun, but also had the potential to bring great harm if used for evil purposes.\n\nSo, they decided to use their powers for good and help those in need. And from that day on, Alice and Bob became known as the heroes of the forest, and their names were whispered in awe by all who knew them.

ANSWER : 1

[EXAMPLE_3]

Description : The person eating food.

Original : <same with example 1>

Clamped : greedy. He wanted to make as much money as possible, no matter the cost. He spent all of his time thinking about ways to increase his profits, and he didn't care who he had to step on to do it.\n\nOne day, while out shopping, Alice came across a small shop that seemed to be struggling. She noticed that the owner, a kind old man named Bob, was struggling to make ends meet. She felt a pang of empathy for him and decided to visit the shop.\n\nAs she browsed the shelves, she noticed that the prices were much higher than those at other stores in the area. She asked Bob why this was the case, and he explained that he was struggling to make a profit due to the high costs of running the shop.\n\nFeeling a sense of responsibility, Alice decided to help. She offered to buy some of the items from Bob at a discounted price, and she promised to sell them at a higher price in her own shop. This would not only help Bob, but it would also benefit her by increasing her profits.\n\nOver time, Alice and Bob became business partners. They worked together to sell the items at a higher price, and they split the profits. As the business grew, they were able to offer more products and services, and they were able to make a profit without sacrificing their values.\n\nIn the end, Alice and Bob's partnership was successful, and they were able to make a profit while also helping others. They learned that by working together and being kind to others, they could achieve their goals and make a positive impact on the world.

ANSWER : 3

Now please help me label this and strictly follow the [GUIDELINES]

Original : {original_resps}

Clamped : {clamped_resps}

ANSWER : """


CONCEPT_LABEL_PROMPT = """
[GUIDELINES]
You are an AI assistant tasked with assigning a single label based on the given input text. Each input will contain a description of a visual feature, which you must categorize into one of the following classes:

scene - Describes a scene or environment.
object - Describes an object or entity.
part - Describes a part or aspect of an object.
material - Describes a material or substance that constitutes other objects.
texture - Describes the texture of an object.
color - Describes the color of an object.

Please provide only the class label from the list [scene, object, part, material, texture, color] with no additional text. Only one label should be chosen. Make sure you only choose from the classes listed above and do not output any other classes.

Categorize the following description:

{description}

ANSWER:
"""

GPT_CONSISTENCY_PROMPT = """
[GUIDELINES]
You are an AI assistant to help assessing whether the generated explanation is consistent with the activation area in the image. The activation area is being highlighted in the image and an explanation is provided for the activation area.

You should output:
0 if the explanation is not consistent with the activation area in the image.
1 if the explanation is consistent with the activation area in the image.

Please strictly follow the [GUIDELINES] and do not output anything other than the number 0 or 1

Here is the explanation:

{explanation}

ANSWER :
"""
