# Code outline
The full code can be found at: [https://github.com/SpaceTime-Vision-Robotics-Laboratory/auto-follow](https://github.com/SpaceTime-Vision-Robotics-Laboratory/auto-follow)


To get the models you can either clone the original repository and have the models already there or follow these instructions:
- Download the models: [https://drive.google.com/drive/folders/1aqAhlVhXATkQd9MspjFmhn8X6KQinJnT?usp=drive_link](https://drive.google.com/drive/folders/1aqAhlVhXATkQd9MspjFmhn8X6KQinJnT?usp=drive_link)
- Put them into [./auto-follow/models](./auto-follow/models)


The bunker environment is neccessary to run the simulated drone tests. However this file is too big for this submission. 
To address this issue, we provided the meshes `.fbx` together with a script to run the environment in the [auto-follow/assets/](./auto-follow/assets/). The documentation for it: [./auto-follow/assets/environment/README.md](./auto-follow/assets/environment/README.md)

Mainly you need to run:
```bash
./run_environment_car.sh -command=parrot-ue4-empty -config=add_mc_laren -quality=low
```

However we have not tested with this method. We tested with the built Unreal Engine 4 Bunker Environment.

### auto-follow
Main repository code.

Requriements:
- Parrot Sphinx Install [https://developer.parrot.com/docs/sphinx/index.html](https://developer.parrot.com/docs/sphinx/index.html)
- In a virtual environment of your choice install the [/auto-follow/requirements.txt](./auto-follow/requirements.txt)
- The bunker environment.
- Note that its best to install [./auto-follow/external/drone_base/](./auto-follow/external/drone_base/) and [auto-follow/](auto-follow/) with `python -m pip install -e`

Important scripts:
- In [./auto-follow/auto_follow/controllers/](./auto-follow/auto_follow/controllers/). To run diverse type of drone controller algorithms. NSER IBVS can be found in [./auto-follow/auto_follow/controllers/ibvs_splitter_controller.py](./auto-follow/auto_follow/controllers/ibvs_splitter_controller.py), while the student controller in [./auto-follow/auto_follow/controllers/eval_distilled_network_controller.py](./auto-follow/auto_follow/controllers/eval_distilled_network_controller.py)
- To run experiments on the simulator you can use [./auto-follow/auto_follow/simulator/simulation_runner.py](./auto-follow/auto_follow/simulator/simulation_runner.py). Just make sure you changed the path to your bunker directory.
- Training the student in [./auto-follow/student_train_pipeline/train_model.py](./auto-follow/student_train_pipeline/train_model.py).
- To evaluate the inferente test [./auto-follow/auto_follow/evaluation/eval_trials_v2.py](./auto-follow/auto_follow/evaluation/eval_trials_v2.py) between the Student (and Student with segmentation) and the Teacher models.
- To visualize and extract statistics, plots and other goodies the scripts in [./auto-follow/auto_follow/visualization/](./auto-follow/auto_follow/visualization/)


### data-labeling-tool
The full code of this tool can be found at: [https://github.com/SpaceTime-Vision-Robotics-Laboratory/data-labeling-tool](https://github.com/SpaceTime-Vision-Robotics-Laboratory/data-labeling-tool)

This contains the code to label the data and train the Mask Splitter Network. 

Just make sure you change the path from `if __name__ == __main__` mostly from `home/user/` into your user.

Important scripts:
- [./data-labeling-tool/car_mask_splitter.py](./data-labeling-tool/car_mask_splitter.py) test the labeling tool with some placeholder images.
- [./data-labeling-tool/generate_segmentations.py](./data-labeling-tool/generate_segmentations.py) - run the segmentation yolo to generate masks
- [./data-labeling-tool/generate_labels.py](./data-labeling-tool/generate_labels.py) - run the annotation tool to split masks
- [./data-labeling-tool/nn/train_splitter_net.py](./data-labeling-tool/nn/train_splitter_net.py) - trains a splitter network 
- [./data-labeling-tool/nn/infer.py](./data-labeling-tool/nn/infer.py) and [./data-labeling-tool/nn/infer_benchmark.py](./data-labeling-tool/nn/infer_benchmark.py) - runs inference on with Mask Splitter.

