import re
import unittest

from drone_base.utils.readable_time import date_time_now_to_file_name


class TestDateTimeToFileName(unittest.TestCase):
    def setUp(self):
        self.MIN_YEAR = 2000
        self.MAX_YEAR = 2100
        self.MIN_MONTH = 1
        self.MAX_MONTH = 12
        self.MIN_DAY = 1
        self.MAX_DAY = 31
        self.MIN_HOUR = 0
        self.MAX_HOUR = 23
        self.MIN_MINUTE = 9
        self.MAX_MINUTE = 59
        self.MIN_SECOND = 0
        self.MAX_SECOND = 59

    def test_date_time_now_to_file_name_format(self):
        """Test that the function returns a string in the expected format"""
        result = date_time_now_to_file_name()

        pattern = r'\d{4}-\d{2}-\d{2}_\d{2}-\d{2}-\d{2}'
        self.assertTrue(re.match(pattern, result),
                        f"Result '{result}' doesn't match expected format YYYY-MM-DD_HH-MM-SS")

        parts = result.replace('_', '-').split('-')
        self.assertEqual(len(parts), 6, "Should have 6 parts: year, month, day, hour, minute, second")

        year = int(parts[0])
        self.assertTrue(self.MIN_YEAR <= year <= self.MAX_YEAR, f"Year should be between 2000-2100, got {year}")

        month = int(parts[1])
        self.assertTrue(self.MIN_MONTH <= month <= self.MAX_MONTH, f"Month should be between 1-12, got {month}")

        day = int(parts[2])
        self.assertTrue(self.MIN_DAY <= day <= self.MAX_DAY, f"Day should be between 1-31, got {day}")

        hour = int(parts[3])
        self.assertTrue(self.MIN_HOUR <= hour <= self.MAX_HOUR, f"Hour should be between 0-23, got {hour}")

        minute = int(parts[4])
        self.assertTrue(self.MIN_MINUTE <= minute <= self.MAX_MINUTE, f"Minute should be between 0-59, got {minute}")

        second = int(parts[5])
        self.assertTrue(self.MIN_SECOND <= second <= self.MAX_SECOND, f"Second should be between 0-59, got {second}")


if __name__ == '__main__':
    unittest.main()
