import glob
import os
import re
from pathlib import Path
from typing import Final


class Paths:
    BASE_DIR: Final[Path] = Path(__file__).resolve().parent
    YOLO_SEGMENTATION_MODEL_PATH: Final[Path] = BASE_DIR / "models" / "yolo-car-full-segmentation.pt"
    YOLO_SEGMENTATION_MODEL_V2_PATH: Final[Path] = BASE_DIR / "models" / "yolo-car-full-segmentation-v2.pt"
    CAR_MASK_SPLITTER_MODEL_PATH: Final[Path] = BASE_DIR / "models" / "mask_splitter-partition-v10-dropout_0-augmentations_multi_scenes.pt"
    CAR_MASK_SPLITTER_MODEL_V2_PATH: Final[Path] = BASE_DIR / "checkpoints" / "mask_splitter-epoch_10-dropout_10-low_x3-and-high_x5_quality.pt"
    CAR_MASK_SPLITTER_MODEL_V_LOW_ONLY_PATH: Final[Path] = BASE_DIR / "checkpoints" / "mask_splitter-epoch_10-dropout_0-low_x3-and-high_x0_quality_early_stop.pt"

    TEST_IMAGES_DIR: Final[Path] = BASE_DIR / "assets" / "images"
    TEST_MASKS_DIR: Final[Path] = BASE_DIR / "assets" / "masks"


def get_path_of_files(directory: str | Path, file_type: str = ".jpg") -> list:
    """
    Function to get a list of paths for every file in a given directory.
    Since the paths will be strings they won't be ordered (e.g., after
    the image 1.jpeg the next image will be 10.jpeg) they were sorted by using a regex.

    :param directory: This must be a string with the path of the directory the videos or the images are in.
    :param file_type: The type of file encoding format e.g., .mp4, .avi, .wmv, .jpg, .png etc.
    :return: A list with paths to the videos or images.
    """
    file_paths = []
    for file_path in glob.glob(os.path.join(directory, f"*{file_type}")):
        file_paths.append(file_path)

    file_paths.sort(key=lambda f: int(re.sub("\\D", "", f)))
    return file_paths


if __name__ == "__main__":
    print(Paths.BASE_DIR)
