# Drone Base Framework

[![Ubuntu](https://github.com/SpaceTime-Vision-Robotics-Laboratory/drone-base/actions/workflows/ubuntu.yml/badge.svg)](https://github.com/SpaceTime-Vision-Robotics-Laboratory/drone-base/actions/workflows/ubuntu.yml)
[![Ruff Linter](https://github.com/SpaceTime-Vision-Robotics-Laboratory/drone-base/actions/workflows/ruff_linter.yml/badge.svg)](https://github.com/SpaceTime-Vision-Robotics-Laboratory/drone-base/actions/workflows/ruff_linter.yml)

[![Python Version](https://img.shields.io/badge/python-3.10%2B-blue)](https://www.python.org/downloads/)
[![License: AFL-3.0](https://img.shields.io/badge/License-AFL3.0-yellow.svg)](https://opensource.org/license/afl-3-0-php)

A modular base framework for building drone control systems using Anafi Parrot drones.

It is designed to be used as a git submodule in drone software projects.

### Features

- Abstraction over drone states, control and streaming.
- Extensible for integrating custom modules
- Lightweight and focused on real-time.

## Installation

### Submodule Installation

To include this framework in your project:

```bash
git submodule add git@github.com:SpaceTime-Vision-Robotics-Laboratory/drone-base.git
git submodule update --init --recursive
```

To clone a project that already includes this as a submodule:

```bash
git clone --recurse-submodules <LINK TO YOUR PROJECT>
```

**Note:** We recommend placing it under `external/` or `libs/` for better structure.

Don't forget to update the submodule often:

```bash
git submodule update --remote external/drone_base
```

**Note:** PyCharm users should mark the **drone_base** directory as sources root for the submodule for
intellisense to work.

To install it via pip you can:

```bash
python -m pip install -e ./external/drone_base
```

### Setup as standalone

Install the packages from the [requirements.txt](requirements.txt).

Can then install it via pip with:

```bash
python -m pip install -e .
```

## Getting started

### Movement Keys

| Key | Action          |
|-----|-----------------|
| i   | Move forward    |
| k   | Move backward   |
| j   | Move right      |
| l   | Move left       |
| o   | Rotate right    |
| u   | Rotate left     |
| n   | Increase height |
| m   | Decrease height |

### Command Keys

| Key | Action                                     |
|-----|--------------------------------------------|
| q   | Stop the drone                             |
| t   | Start take off                             |
| y   | Land the drone                             |
| p   | Take a photo                               |
| z   | Reset the gimbal camera position           |
| x   | Tilt the gimbal camera position 15 degrees |
| c   | Tilt the gimbal camera position 30 degrees |
| v   | Tilt the gimbal camera position 45 degrees |
| s   | Tilt the gimbal camera position 60 degrees |
| d   | Tilt the gimbal camera position 75 degrees |
| f   | Tilt the gimbal camera position 90 degrees |

## Example of usages:

Run the example [controller](examples/display_only_controller.py) that only displays the video stream from the drone and
has keyboard control.

```bash
python -m examples.display_only_controller
```

Run the [video to frame](drone_base/stream/saving/frames_to_video.py) to create a video from the frames generated
from the video stream of a mission:

```bash
python -m drone_base.stream.saving.frames_to_video
```

## License

This project is licensed under the Academic Free License v3.0 - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

- [Parrot Olympe SDK](https://developer.parrot.com/docs/olympe/index.html#)
- [Parrot Sphinx](https://developer.parrot.com/docs/sphinx/index.html)
- Space Time Vision Robotics Laboratory