from dataclasses import dataclass
from enum import Enum, auto


class DroneCommand(Enum):
    TAKEOFF = auto()
    LAND = auto()
    PHOTO = auto()
    TILT_RESET = auto()
    TILT_15 = auto()
    TILT_30 = auto()
    TILT_45 = auto()
    TILT_60 = auto()
    TILT_75 = auto()
    TILT_90 = auto()
    EMERGENCY_STOP = auto()


@dataclass
class MovementVector:
    """Data class to represent drone movement"""
    x: int = 0
    y: int = 0
    z: int = 0
    z_rot: int = 0

    def reset(self):
        """Reset all movement values to 0"""
        self.x = 0
        self.y = 0
        self.z = 0
        self.z_rot = 0

    def is_moving(self) -> bool:
        """Check if there is any active movement."""
        return self.x != 0 or self.y != 0 or self.z != 0 or self.z_rot != 0
