import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torchvision import datasets, transforms
from torch.utils.data import DataLoader, Dataset
from torch.autograd import Variable
import matplotlib.pyplot as plt
import numpy as np
import torchvision.models as models
import time
import densenetcont
  



clf = densenetcont.DenseNet()        

device=torch.device("cuda:0")
clf.to(device)
clf.load_state_dict(torch.load("densenetcont_19_.pt"))

clf.eval()
#print(clf)
#for p in clf.parameters():
for p in clf.features.children():
    if isinstance(p, densenetcont.ContinuousPool):
        print(p.pool_strength.shape)
        avg_str=p.pool_strength.mean(0).squeeze().detach().cpu().numpy()
        print(avg_str.shape)
        plt.plot(avg_str)
        plt.show()
    if isinstance(p, densenetcont._Transition):
        #print(p)
        print(p[3].pool_strength.shape)
        avg_str=p[3].pool_strength.mean(0).squeeze().detach().cpu().numpy()
        plt.plot(avg_str)
        plt.show()
        

