#!/usr/bin/env python2

# %%

import os.path as path
import pickle

# %%

n = 5

for version in "base", "final":
    mean = {}
    for i in range(n):
        filename = "{}_{}.p".format(version, i)
        with open(path.join("results", "evaluate_hbp", filename), "rb") as p:
            results = pickle.load(p)
            for item in results:
                if item not in mean:
                    mean[item] = results[item] / n
                else:
                    mean[item] += results[item] / n
    headers = []
    values = []
    for header in sorted(mean):
        headers.append(header)
        values.append(mean[header])
    print(",".join(["version"] + headers))
    print(",".join([version] + [str(value) for value in values]))
