#!/usr/bin/env bash

#SBATCH --cpus-per-task=2
#SBATCH --gpus-per-task=1
#SBATCH --job-name=conv_mnist_2
#SBATCH --mem-per-cpu=8GB
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=2
#SBATCH --output=outputs/optimize_conv_mnist_2.txt
#SBATCH --partition=batch_default
#SBATCH --requeue
#SBATCH --time=2-00:00:00

# Cold and non-sparse
# A 0.5% accuracy drop is worth it if it halves latency and power consumption
ARGS="
    --granularities 1 2 3
    --global-v-initial 0.0
    --id 2
    --lambdas 200.0 1.0 1.0
    --max-iterations 100 1000 10000
    --ranks-per-node 2
    --auto-scale 0 1 1
    --n-time-chunks 2
    --val-freq 10
"

mpirun -n 2 ./scripts/optimize.py \
    models/snn/conv_mnist.h5 \
    models/ann/conv_mnist.h5 \
    $ARGS
