#!/usr/bin/env python3

import os.path as path

from keras.layers import *
from keras.models import Sequential

model = Sequential()
model.add(Flatten(input_shape=(28, 28, 1)))
for _ in range(2):
    model.add(Dense(128))
    model.add(BatchNormalization(scale=False))
    model.add(Activation("relu"))
model.add(Dense(10))
model.add(Activation("softmax"))

# Loading weights is a way to check that the architecture is correct
model.load_weights(path.join("models", "ann", "dense_mnist.h5"))

model.compile(optimizer="rmsprop",
              loss="categorical_crossentropy",
              metrics=[])
model.save(path.join("models", "ann", "dense_mnist_snn-tb.h5"))
