#!/usr/bin/env bash

for BETA in 2e-1 5e-1 1e0 2e0
do
    for L1 in 5e0 1e1 2e1 5e1
    do
        ARGS="
            --beta-penalty $BETA
            --epochs 200
            --id b${BETA}_L${L1}
            --l1-synapse-penalty $L1
            --l2-decay 1e-3
            --learning-rates 5e-3 1e-3
            --learning-rate-boundaries 100
            --optimizer SGD
        "

        ./scripts/train.py pool mnist -w models/ann/pool_mnist.h5 $ARGS
    done
done
