#!/usr/bin/env python3

# %%

import os.path as path
import pickle

# %%

path_r = path.join("results", "optimize", "conv_mnist_sparse.p")
with open(path_r, "rb") as file:
    results = pickle.load(file)

# %%

path_w = path.join("results", "optimize", "conv_mnist_sparse_v_init.csv")
with open(path_w, "w") as file:
    for x in results[-1]["v_initial"]:
        if isinstance(x, float):
            file.write(str(x))
        else:
            file.write(",".join(map(str, x)))
        file.write("\n")
