#!/usr/bin/env python3

import os.path as path
import pickle

from sarnn.pynn import PyNNModel
from sarnn.utils import load_model
from snn.utils import ensure_exists, load_snn_dataset

(x, y), _ = load_snn_dataset("mnist", "test")
ensure_exists("data")
with open(path.join("data", "mnist_test.p"), "wb") as pickle_file:
    pickle.dump({"x": x, "y": y}, pickle_file, protocol=2)

snn = load_model(path.join("models", "snn", "pool_mnist.h5"))
snn_pynn = PyNNModel.from_keras(snn)
ensure_exists(path.join("models", "hbp"))
snn_pynn.save(path.join("models", "hbp", "base.p"))
