#!/usr/bin/env bash

#SBATCH --cpus-per-task=2
#SBATCH --gpus-per-task=1
#SBATCH --job-name=mobilenet_final
#SBATCH --mem-per-cpu=8GB
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=4
#SBATCH --output=results/evaluate_snn/mobilenet_final.csv
#SBATCH --partition=batch_default
#SBATCH --requeue
#SBATCH --time=5-00:00:00

ARGS="
    --ann-filename models/ann/mobilenet_imagenet_sparse.h5
    --threshold 0.48862
    --ranks-per-node 4
    --n-time-chunks 500
    --v-initial-filename results/optimize/mobilenet_imagenet_sparse.p
"

mpirun -n 4 ./scripts/evaluate_snn.py \
    ./models/optimized/mobilenet_imagenet_sparse.h5 \
    $ARGS