#!/usr/bin/env bash

#SBATCH --cpus-per-task=4
#SBATCH --gres=gpu:4
#SBATCH --job-name=train_mobilenet
#SBATCH --mem-per-gpu=8GB
#SBATCH --output=outputs/train_mobilenet.txt
#SBATCH --partition=batch_default
#SBATCH --time=4-00:00:00

ARGS="
    --epochs 50
    --l2-decay 1e-3
    --learning-rates 1e-2 1e-3
    --learning-rate-boundaries 25
    --optimizer SGD
"

./scripts/train.py mobilenet imagenet $ARGS
