#!/usr/bin/env bash

#SBATCH --cpus-per-task=4
#SBATCH --gres=gpu:4
#SBATCH --job-name=b5e0_L2e2
#SBATCH --mem-per-gpu=8GB
#SBATCH --output=outputs/mobilenet_sparse/b5e0_L2e2.txt
#SBATCH --partition=batch_default
#SBATCH --time=4-00:00:00

BETA=5e0
L1=2e2

ARGS="
    --beta-penalty $BETA
    --epochs 50
    --id b${BETA}_L${L1}
    --l1-synapse-penalty $L1
    --l2-decay 1e-3
    --learning-rates 1e-3 1e-4
    --learning-rate-boundaries 25
    --optimizer SGD
    --weight-file models/ann/mobilenet_imagenet.h5
"

./scripts/train.py mobilenet imagenet $ARGS
