"""Optimize Rbf for the mannequin measurement"""
import matplotlib.pyplot as plt
from totri.data import VeltenNc2012, repo_path


def make_figures():
    file_name = repo_path('data/veltennc2012/gandalf/dataset_Gandalf.mat')
    ds = VeltenNc2012(file_name, device='cuda')

    # Crop measurement
    scan_start = 40
    scan_end = scan_start + 224
    ds.transient   = ds.transient[:,:,scan_start:scan_end,:]
    ds.scan_points = ds.scan_points[:,scan_start:scan_end,:]

    scan_points = ds.scan_points.cpu()
    laser_points = ds.laser_points.cpu()

    print(scan_points[0].min(dim=0))
    print(scan_points[0].max(dim=0))

    fig = plt.figure(figsize=(3,3))
    plt.scatter(scan_points[0,::7,0], scan_points[0,::7,1], marker="x", s=1.0, label='detector (subset)')
    plt.scatter(laser_points[0,:,0], laser_points[0,:,1], label='laser', s=2.0)
    plt.axis('off')
    plt.tight_layout()
    plt.legend()
    plt.savefig(repo_path('samples/wacv/mannequin/mannequin_setup.png'), bbox_inches='tight', pad_inches=0)
    plt.savefig(repo_path('samples/wacv/mannequin/mannequin_setup.eps'), bbox_inches='tight', pad_inches=0)


make_figures()
