"""Render bunny obj for reference"""
import torch
from pytorch3d.io import load_obj
from torchvision.utils import save_image
from totri.data import repo_path
from totri.util.render import UnitCubeMeshRender

# Load Mesh
obj_path = repo_path('data/zaragoza/bunny_l[0.00,-0.50,0.00]_r[1.57,0.00,3.14]_v[0.21]_bunny.obj')
verts_gt, faces_gt, aux = load_obj(obj_path, device='cuda')
verts_gt = torch.stack((verts_gt[:,0], verts_gt[:,2], -verts_gt[:,1]), dim=-1)
faces_gt = faces_gt.verts_idx

img = UnitCubeMeshRender(512, distance=0.07, specular=0).apply(verts_gt, faces_gt)
save_image(img, repo_path(f'samples/wacv/bunny_zaragoza/bunny_gt.jpg'))
