#%% Import packages
import os
import h5py
import numpy as np
from glob import glob

def convert_files(source_dir, destination_dir, type):
    if(type == "training"):
        list_files = glob(source_dir+"*/*.h5")
        for file in list_files:
            folder = file.split("\\")[1]
            file_name = file.split("\\")[-1].split(".")[0]
            with h5py.File(file, 'r') as f:
                depth = f["depth"][:]
                os.makedirs(destination_dir+"depths/"+folder, exist_ok=True)
                np.save(destination_dir+"depths/"+folder+"/"+file_name+".npy", depth)
                
    elif(type == "testing"):
        list_files = glob(source_dir+"*.h5")
        for i, file in enumerate(list_files):
            file_name = file.split("\\")[-1].split(".")[0]
            with h5py.File(file, 'r') as f:
                depth = f["depth"][:]
                np.save(destination_dir+"depths/"+file_name+".npy", depth)

if __name__=="__main__":
    training_source = "../../dataset/nyu/nyudepthv2/train/"
    testing_source = "../../dataset/nyu/nyudepthv2/val/official/"
    
    training_dest = "../../dataset/nyu/converted/train/"    
    testing_dest = "../../dataset/nyu/converted/test/"

    convert_files(training_source, training_dest, "training")
    convert_files(testing_source, testing_dest, "testing")