import mmcv
import numpy as np

from .builder import DATASETS
from .imagenet import ImageNet


@DATASETS.register_module()
class ImageNet127(ImageNet):

    CLASSMAP = {
        0: 126, 1: 126, 2: 107, 3: 107, 4: 107,
        5: 38, 6: 38, 7: 104, 8: 104, 9: 104,
        10: 104, 11: 104, 12: 104, 13: 104, 14: 104,
        15: 104, 16: 104, 17: 104, 18: 104, 19: 104,
        20: 104, 21: 104, 22: 104, 23: 104, 24: 104,
        25: 97, 26: 97, 27: 97, 28: 97, 29: 97,
        30: 13, 31: 13, 32: 13, 33: 96, 34: 96,
        35: 96, 36: 96, 37: 96, 38: 78, 39: 116,
        40: 116, 41: 24, 42: 87, 43: 87, 44: 6,
        45: 102, 46: 49, 47: 122, 48: 125, 49: 62,
        50: 15, 51: 75, 52: 89, 53: 89, 54: 89,
        55: 89, 56: 89, 57: 89, 58: 89, 59: 89,
        60: 89, 61: 89, 62: 89, 63: 89, 64: 89,
        65: 89, 66: 89, 67: 89, 68: 89, 69: 65,
        70: 65, 71: 65, 72: 65, 73: 65, 74: 65,
        75: 65, 76: 65, 77: 65, 78: 65, 79: 65,
        80: 104, 81: 104, 82: 104, 83: 104, 84: 104,
        85: 104, 86: 104, 87: 104, 88: 104, 89: 104,
        90: 104, 91: 104, 92: 104, 93: 104, 94: 104,
        95: 104, 96: 104, 97: 104, 98: 104, 99: 104,
        100: 104, 101: 86, 102: 86, 103: 86, 104: 86,
        105: 86, 106: 86, 107: 14, 108: 14, 109: 14,
        110: 100, 111: 100, 112: 68, 113: 68, 114: 68,
        115: 68, 116: 68, 117: 68, 118: 65, 119: 65,
        120: 65, 121: 65, 122: 65, 123: 65, 124: 65,
        125: 65, 126: 65, 127: 104, 128: 104, 129: 104,
        130: 104, 131: 104, 132: 104, 133: 104, 134: 104,
        135: 104, 136: 104, 137: 104, 138: 104, 139: 104,
        140: 104, 141: 104, 142: 104, 143: 104, 144: 104,
        145: 104, 146: 104, 147: 86, 148: 86, 149: 86,
        150: 86, 151: 86, 152: 86, 153: 86, 154: 86,
        155: 86, 156: 86, 157: 86, 158: 86, 159: 86,
        160: 86, 161: 86, 162: 86, 163: 86, 164: 86,
        165: 86, 166: 86, 167: 86, 168: 86, 169: 86,
        170: 86, 171: 86, 172: 86, 173: 86, 174: 86,
        175: 86, 176: 86, 177: 86, 178: 86, 179: 86,
        180: 86, 181: 86, 182: 86, 183: 86, 184: 86,
        185: 86, 186: 86, 187: 86, 188: 86, 189: 86,
        190: 86, 191: 86, 192: 86, 193: 86, 194: 86,
        195: 86, 196: 86, 197: 86, 198: 86, 199: 86,
        200: 86, 201: 86, 202: 86, 203: 86, 204: 86,
        205: 86, 206: 86, 207: 86, 208: 86, 209: 86,
        210: 86, 211: 86, 212: 86, 213: 86, 214: 86,
        215: 86, 216: 86, 217: 86, 218: 86, 219: 86,
        220: 86, 221: 86, 222: 86, 223: 86, 224: 86,
        225: 86, 226: 86, 227: 86, 228: 86, 229: 86,
        230: 86, 231: 86, 232: 86, 233: 86, 234: 86,
        235: 86, 236: 86, 237: 86, 238: 86, 239: 86,
        240: 86, 241: 86, 242: 86, 243: 86, 244: 86,
        245: 86, 246: 86, 247: 86, 248: 86, 249: 86,
        250: 86, 251: 86, 252: 86, 253: 86, 254: 86,
        255: 86, 256: 86, 257: 86, 258: 86, 259: 86,
        260: 86, 261: 86, 262: 86, 263: 86, 264: 86,
        265: 86, 266: 86, 267: 86, 268: 86, 269: 86,
        270: 86, 271: 86, 272: 86, 273: 86, 274: 86,
        275: 86, 276: 86, 277: 86, 278: 86, 279: 86,
        280: 86, 281: 86, 282: 86, 283: 86, 284: 86,
        285: 86, 286: 86, 287: 86, 288: 86, 289: 86,
        290: 86, 291: 86, 292: 86, 293: 86, 294: 86,
        295: 86, 296: 86, 297: 86, 298: 86, 299: 86,
        300: 65, 301: 65, 302: 65, 303: 65, 304: 65,
        305: 65, 306: 65, 307: 65, 308: 65, 309: 65,
        310: 65, 311: 65, 312: 65, 313: 65, 314: 65,
        315: 65, 316: 65, 317: 65, 318: 65, 319: 65,
        320: 65, 321: 65, 322: 65, 323: 65, 324: 65,
        325: 65, 326: 65, 327: 54, 328: 54, 329: 54,
        330: 86, 331: 86, 332: 86, 333: 86, 334: 86,
        335: 86, 336: 86, 337: 86, 338: 86, 339: 86,
        340: 86, 341: 86, 342: 86, 343: 86, 344: 86,
        345: 86, 346: 86, 347: 86, 348: 86, 349: 86,
        350: 86, 351: 86, 352: 86, 353: 86, 354: 86,
        355: 86, 356: 86, 357: 86, 358: 86, 359: 86,
        360: 86, 361: 86, 362: 86, 363: 86, 364: 86,
        365: 86, 366: 86, 367: 86, 368: 86, 369: 86,
        370: 86, 371: 86, 372: 86, 373: 86, 374: 86,
        375: 86, 376: 86, 377: 86, 378: 86, 379: 86,
        380: 86, 381: 86, 382: 86, 383: 86, 384: 86,
        385: 86, 386: 86, 387: 86, 388: 86, 389: 124,
        390: 126, 391: 124, 392: 61, 393: 7, 394: 108,
        395: 108, 396: 82, 397: 79, 398: 12, 399: 44,
        400: 90, 401: 12, 402: 12, 403: 10, 404: 67,
        405: 112, 406: 76, 407: 117, 408: 117, 409: 12,
        410: 76, 411: 36, 412: 117, 413: 12, 414: 117,
        415: 76, 416: 47, 417: 112, 418: 70, 419: 83,
        420: 12, 421: 76, 422: 32, 423: 16, 424: 76,
        425: 76, 426: 12, 427: 117, 428: 117, 429: 34,
        430: 34, 431: 16, 432: 12, 433: 5, 434: 95,
        435: 117, 436: 117, 437: 76, 438: 117, 439: 123,
        440: 117, 441: 117, 442: 83, 443: 103, 444: 117,
        445: 44, 446: 83, 447: 12, 448: 83, 449: 76,
        450: 56, 451: 44, 452: 123, 453: 16, 454: 76,
        455: 83, 456: 12, 457: 44, 458: 76, 459: 44,
        460: 76, 461: 83, 462: 94, 463: 117, 464: 12,
        465: 83, 466: 98, 467: 76, 468: 117, 469: 27,
        470: 12, 471: 12, 472: 119, 473: 23, 474: 44,
        475: 12, 476: 12, 477: 57, 478: 117, 479: 12,
        480: 12, 481: 117, 482: 17, 483: 76, 484: 18,
        485: 17, 486: 12, 487: 17, 488: 3, 489: 76,
        490: 83, 491: 12, 492: 117, 493: 16, 494: 12,
        495: 16, 496: 84, 497: 76, 498: 76, 499: 23,
        500: 76, 501: 83, 502: 83, 503: 117, 504: 117,
        505: 27, 506: 76, 507: 12, 508: 17, 509: 76,
        510: 35, 511: 117, 512: 23, 513: 12, 514: 83,
        515: 123, 516: 16, 517: 12, 518: 26, 519: 117,
        520: 16, 521: 106, 522: 34, 523: 21, 524: 83,
        525: 76, 526: 16, 527: 12, 528: 17, 529: 44,
        530: 12, 531: 12, 532: 16, 533: 103, 534: 42,
        535: 12, 536: 76, 537: 56, 538: 83, 539: 83,
        540: 121, 541: 12, 542: 21, 543: 32, 544: 42,
        545: 12, 546: 12, 547: 117, 548: 16, 549: 117,
        550: 42, 551: 71, 552: 44, 553: 16, 554: 119,
        555: 117, 556: 83, 557: 21, 558: 12, 559: 16,
        560: 26, 561: 117, 562: 76, 563: 70, 564: 16,
        565: 117, 566: 12, 567: 80, 568: 44, 569: 117,
        570: 83, 571: 12, 572: 117, 573: 117, 574: 34,
        575: 41, 576: 119, 577: 12, 578: 113, 579: 12,
        580: 76, 581: 76, 582: 76, 583: 12, 584: 12,
        585: 71, 586: 10, 587: 23, 588: 117, 589: 12,
        590: 12, 591: 103, 592: 12, 593: 12, 594: 12,
        595: 12, 596: 23, 597: 83, 598: 76, 599: 76,
        600: 12, 601: 44, 602: 47, 603: 117, 604: 12,
        605: 17, 606: 42, 607: 12, 608: 44, 609: 117,
        610: 44, 611: 34, 612: 117, 613: 12, 614: 44,
        615: 36, 616: 12, 617: 44, 618: 117, 619: 83,
        620: 12, 621: 23, 622: 83, 623: 23, 624: 76,
        625: 119, 626: 12, 627: 117, 628: 35, 629: 71,
        630: 83, 631: 71, 632: 12, 633: 12, 634: 76,
        635: 12, 636: 117, 637: 117, 638: 84, 639: 44,
        640: 83, 641: 12, 642: 12, 643: 83, 644: 21,
        645: 12, 646: 59, 647: 117, 648: 16, 649: 76,
        650: 12, 651: 42, 652: 50, 653: 117, 654: 25,
        655: 44, 656: 117, 657: 64, 658: 55, 659: 117,
        660: 76, 661: 117, 662: 17, 663: 76, 664: 17,
        665: 117, 666: 117, 667: 5, 668: 76, 669: 83,
        670: 117, 671: 117, 672: 76, 673: 12, 674: 12,
        675: 117, 676: 12, 677: 12, 678: 12, 679: 2,
        680: 83, 681: 12, 682: 76, 683: 12, 684: 12,
        685: 12, 686: 12, 687: 12, 688: 17, 689: 44,
        690: 117, 691: 12, 692: 117, 693: 93, 694: 12,
        695: 12, 696: 12, 697: 45, 698: 76, 699: 12,
        700: 103, 701: 88, 702: 47, 703: 16, 704: 12,
        705: 117, 706: 76, 707: 17, 708: 76, 709: 117,
        710: 48, 711: 71, 712: 117, 713: 92, 714: 12,
        715: 83, 716: 76, 717: 117, 718: 12, 719: 117,
        720: 117, 721: 118, 722: 34, 723: 12, 724: 35,
        725: 117, 726: 23, 727: 76, 728: 117, 729: 76,
        730: 23, 731: 23, 732: 60, 733: 30, 734: 117,
        735: 44, 736: 34, 737: 117, 738: 117, 739: 12,
        740: 23, 741: 83, 742: 17, 743: 76, 744: 12,
        745: 12, 746: 12, 747: 34, 748: 117, 749: 70,
        750: 83, 751: 117, 752: 53, 753: 12, 754: 59,
        755: 12, 756: 69, 757: 117, 758: 12, 759: 60,
        760: 42, 761: 12, 762: 76, 763: 12, 764: 12,
        765: 16, 766: 42, 767: 101, 768: 34, 769: 12,
        770: 83, 771: 117, 772: 12, 773: 117, 774: 83,
        775: 44, 776: 12, 777: 83, 778: 12, 779: 25,
        780: 18, 781: 20, 782: 12, 783: 12, 784: 23,
        785: 91, 786: 42, 787: 83, 788: 76, 789: 83,
        790: 117, 791: 117, 792: 23, 793: 5, 794: 83,
        795: 12, 796: 83, 797: 117, 798: 12, 799: 76,
        800: 12, 801: 12, 802: 117, 803: 117, 804: 117,
        805: 34, 806: 84, 807: 12, 808: 123, 809: 117,
        810: 85, 811: 12, 812: 52, 813: 109, 814: 119,
        815: 12, 816: 21, 817: 117, 818: 12, 819: 9,
        820: 117, 821: 76, 822: 12, 823: 12, 824: 44,
        825: 76, 826: 12, 827: 12, 828: 12, 829: 117,
        830: 58, 831: 16, 832: 76, 833: 10, 834: 44,
        835: 12, 836: 12, 837: 12, 838: 71, 839: 76,
        840: 94, 841: 44, 842: 44, 843: 12, 844: 12,
        845: 12, 846: 16, 847: 117, 848: 17, 849: 27,
        850: 19, 851: 59, 852: 34, 853: 83, 854: 83,
        855: 83, 856: 12, 857: 16, 858: 83, 859: 42,
        860: 76, 861: 16, 862: 12, 863: 76, 864: 117,
        865: 76, 866: 117, 867: 117, 868: 117, 869: 44,
        870: 117, 871: 18, 872: 12, 873: 76, 874: 25,
        875: 12, 876: 117, 877: 76, 878: 12, 879: 83,
        880: 117, 881: 12, 882: 42, 883: 117, 884: 83,
        885: 103, 886: 12, 887: 90, 888: 76, 889: 12,
        890: 34, 891: 42, 892: 12, 893: 117, 894: 16,
        895: 67, 896: 117, 897: 42, 898: 117, 899: 117,
        900: 117, 901: 117, 902: 12, 903: 22, 904: 83,
        905: 83, 906: 44, 907: 117, 908: 12, 909: 80,
        910: 117, 911: 103, 912: 76, 913: 35, 914: 119,
        915: 76, 916: 12, 917: 99, 918: 34, 919: 105,
        920: 43, 921: 83, 922: 46, 923: 74, 924: 39,
        925: 28, 926: 28, 927: 63, 928: 31, 929: 31,
        930: 0, 931: 73, 932: 77, 933: 28, 934: 28,
        935: 1, 936: 1, 937: 1, 938: 1, 939: 1,
        940: 1, 941: 1, 942: 1, 943: 1, 944: 1,
        945: 1, 946: 1, 947: 1, 948: 4, 949: 4,
        950: 4, 951: 4, 952: 4, 953: 4, 954: 4,
        955: 4, 956: 4, 957: 4, 958: 40, 959: 37,
        960: 37, 961: 111, 962: 28, 963: 28, 964: 28,
        965: 28, 966: 72, 967: 114, 968: 81, 969: 81,
        970: 33, 971: 8, 972: 33, 973: 33, 974: 33,
        975: 33, 976: 33, 977: 120, 978: 33, 979: 33,
        980: 33, 981: 29, 982: 110, 983: 115, 984: 4,
        985: 51, 986: 51, 987: 4, 988: 4, 989: 4,
        990: 4, 991: 11, 992: 11, 993: 11, 994: 11,
        995: 11, 996: 11, 997: 11, 998: 4, 999: 66,
    }

    def load_annotations(self):
        """Load image paths and gt_labels."""
        if self.ann_file is None:
            samples = self._find_samples()
        elif isinstance(self.ann_file, str):
            lines = mmcv.list_from_file(
                self.ann_file, file_client_args=self.file_client_args)
            samples = [x.strip().rsplit(' ', 1) for x in lines]
        else:
            raise TypeError('ann_file must be a str or None')

        data_infos = []
        for filename, gt_label in samples:
            info = {'img_prefix': self.data_prefix}
            info['img_info'] = {'filename': filename}
            info['gt_label'] = np.array(
                self.CLASSMAP[int(gt_label)], dtype=np.int64
            )
            data_infos.append(info)
        return data_infos
