# Hyperbolic vs Euclidean Embeddings in Few-Shot Learning: Two Sides of the Same Coin
# Supplementary for paper 786 (WACV 2024)


We provide a PDF with additional explanations and Python code to reproduce all experiments.


## CONFIGURATION
Edit the cfg dictionary in ./code/train_fewshot.py according to the desired training specifications (see paper).
Examples:

cfg['manifold'] can be 'euclidean', 'poincare' or 'spherical'
	cfg['manifold']   = 'euclidean' (ProtoNet)
	cfg['manifold']   = 'poincare' (Poincaré network), 
	cfg['manifold']   = 'spherical' (Euclidean with fixed-radius as proposed in the paper)

cfg['manifold_k'] is the curvature of the manifold above
	cfg['manifold_k'] = 0.0 (Always 0.0 in 'euclidean')
	cfg['manifold_k'] = -0.01 (Always negative in 'poincare')
	cfg['manifold_k'] = 0.002 (Always positive in 'spherical', fixed-radius will be 1/sqrt(k))

cfg['metric'] can be 'euclidean', 'squared_euclidean' or 'poincare'
	cfg['metric']     = 'squared_euclidean' (Always used with 'euclidean' manifolds. This is the original metric of ProtoNet)
	cfg['metric']     = 'euclidean' (This is the metric we used for fixed-radius manifolds)
	cfg['metric']     = 'poincare' (This is the metric used for poincare manifolds)

cfg['metric_k'] is the curvature of the metric above. Either zero or negative for 'poincare' metric.
	cfg['metric_k']   = 0.0 (Always 0.0 for 'euclidean' and 'squared_euclidean' metrics)
	cfg['metric_k']   = -0.01 (Always negative and equal to 'manifold_k' for 'poincare')

Proposed fixed-radius example:
	cfg['manifold']   = 'spherical'
	cfg['manifold_k'] = 0.002
	cfg['metric']     = 'euclidean'
	cfg['metric_k']   = 0.0

ProtoNet example:
	cfg['manifold']   = 'euclidean'
	cfg['manifold_k'] = 0.0
	cfg['metric']     = 'squared_euclidean'
	cfg['metric_k']   = 0.0

Poincaré example:
	cfg['manifold']   = 'poincare'
	cfg['manifold_k'] = -0.01
	cfg['metric']     = 'poincare'
	cfg['metric_k']   = -0.01


## TRAINING 
Create an experiments folder in the parent directory of ./code/

    mkdir ./experiments/

Training splits are provided in the dataset folders ./CUB_200_2011/ and ./MINI_IMAGENET/
These splits are the original ones from each dataset, but in a different format
Move to the parent directory and run the train_fewshot.py script.

    python ./code/train_fewshot.py

During training an automatic experiment name is generated and the best model weights will be stored at ./experiments/<experiment_name>/best_weights.pt
The cfg dictionary is saved as ./experiments/<experiment_name>/cfg.json
The tracker CSV with train and validation accuracies and losses is saved as ./experiments/<experiment_name>/tracker.csv 


## TESTING
For testing a trained model run the test script with the experiment name and the shot/way/query regime you want to test it on as arguments.

    python ./code/test_fewshot.py ./experiments/<experiment_name> <shot> <way> <query>

In the paper, query is always 15 and we provided results for 1-shot 5-way and 5-shot 5-way. 
Thus, the last three arguments should be 1 5 15 or 5 5 15


Training and testing performed on a NVIDIA Quadro RTX 8000.
