

## Usage

### Train simsiam/barlowtwins

1. contrastive learning

- set **--data_root** to the path of STL10, CIFAR10, CIFAR100, and **--dataset_type** to the corresponding dataset type.
- set **--net** to simsiam or barlowtwins to train the corrsponding network.
- (optional) **--aug aug1** for Basic Augmentation (BAug) described in the paper; **--aug aug1_2** for Complex Augmentation (CAug) described in the paper.
- (optional) **--warmup_epochs 30** for trianing with 30-epoch warmup; **--warmup_epochs 0** for trianing without warmup.

```bash
mkdir -p ./logs/exp1/
mkdir -p ./Results/exp1/

python main.py --data_root <path to dataset of STL10, CIFAR10, CIFAR100> --exp_dir ./logs/exp1/ --trial trial1 --arch resnet18 --learning_rate 0.06 --epochs 100 --weight_decay 5e-4 --momentum 0.9 --batch_size 512 --eval_freq 1 --gpu 0 --net simsiam --hp1 1.0 --aug aug1 --warmup_epochs 30 --dataset_type STL10 > ./Results/exp1/trial1.txt
```

2. linear evaluation

- set **--data** to the path of STL10, CIFAR10, CIFAR100, and **--dataset_type** to the corresponding dataset type.

```bash
python main_lincls.py --arch resnet18 --batch_size 256 --lr 30.0 --weight_decay 0.0 --pretrained ./logs/exp1/trial1/ckpt_epoch_100_trial1.pth --data <path to dataset of STL10, CIFAR10, CIFAR100> --exp_dir ./logs/exp1/trial1/ --gpu 0 --filename1 checkpoint_100.pth.tar --filename2 checkpoint_100_best.pth.tar --dataset_type STL10 > ./Results/exp1/linear100_trial1.txt
```

### Train DDCL_Asy/DDCL_Sym

1. contrastive learning

- set **--data_root** to the path of STL10, CIFAR10, CIFAR100, and **--dataset_type** to the corresponding dataset type
- set **--net SepCL_v1_Simsiam_OTL1** for training DDCL_Asy, or **--net SepCL_v1_OTL1** for training DDCL_Sym.
- (optional) **--aug aug1** for Basic Augmentation (BAug) described in the paper; **--aug aug1_2** for Complex Augmentation (CAug) described in the paper.
- (optional) **--warmup_epochs 30** for trianing with 30-epoch warmup; **--warmup_epochs 0** for trianing without warmup.
- (optional) **--hp1 0.8** represents the disentangling ratio, DR (DIR parts taking 0.8 of total dimension and the DVR parts taking 0.2 of total dimension).

```bash
## train
mkdir -p ./logs/exp1/
mkdir -p ./Results/exp1/

python main.py --data_root /home/sifan2/Datasets --exp_dir ./logs/exp1/ --trial trial1 --arch resnet18 --learning_rate 0.06 --epochs 100 --weight_decay 5e-4 --momentum 0.9 --batch_size 512 --eval_freq 1 --gpu 0 --net SepCL_v1_OTL1 --hp1 0.8 --aug aug1 --sep_lambd 1.0 --warmup_epochs 30 --dataset_type STL10 > ./Results/exp1/trial1.txt
```

2. linear evaluation

- set **--data** to the path of STL10, CIFAR10, CIFAR100, and **--dataset_type** to the corresponding dataset type.

```bash
## train linear evaluation using the overall representations (DIR + DVR)
python main_lincls.py --arch resnet18 --batch_size 256 --lr 30.0 --weight_decay 0.0 --pretrained ./logs/exp1/trial1/ckpt_epoch_100_trial1.pth --data <path to dataset of STL10, CIFAR10, CIFAR100> --exp_dir ./logs/exp1/trial1/ --gpu 0 --filename1 checkpoint_100.pth.tar --filename2 checkpoint_100_best.pth.tar --dataset_type STL10 > ./Results/exp1/linear100_trial1.txt

## train linear evaluation using only DIR part (by setting --hp1 0.8)
python main_lincls.py --arch resnet18 --batch_size 256 --lr 30.0 --weight_decay 0.0 --pretrained ./logs/exp1/trial1/ckpt_epoch_100_trial1.pth --data <path to dataset of STL10, CIFAR10, CIFAR100> --exp_dir ./logs/exp1/trial1/ --gpu ${GPU_num} --filename1 linear_checkpoint_100.pth.tar --filename2 linear_checkpoint_100_best.pth.tar --hp1 0.8 --dataset_type STL10 > ./Results/exp1/linear100_trial1_hp0.8.txt

```