import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from scene_graph.extraction.carla_extractor import CarlaExtractor
from scene_graph.extraction.image_extractor import RealExtractor
from scene_graph.extraction.carla_image_extractor import CarlaRealExtractor
from util.config_parser import configuration
from util.script_exceptions import Invalid_Dataset_Type
from roadscene2vec.util.visualizer import visualize

#python 2_extract_scene_graphs.py --yaml_path /home/harsimrat/sg2vec/roadscene2vec/config/scenegraph_extraction_config.yaml

'''This script runs scene graph extraction of Carla or Real data'''
def extract_scene_graphs(scene_config):
    
    if scene_config.dataset_type == "carla":
        sg_extraction_object = CarlaExtractor(scene_config)
    elif scene_config.dataset_type == "image": #must calibrate birds eye view for real data
        if scene_config.data_format == 'honda':
            sg_extraction_object = RealExtractor(scene_config)
        elif scene_config.data_format == 'carla':
            sg_extraction_object = CarlaRealExtractor(scene_config)
    else:
        raise Invalid_Dataset_Type("Please input a valid dataset type")
    sg_extraction_object.load()
    scenegraph_dataset = sg_extraction_object.getDataSet() #returned scenegraphs from extraction
    scenegraph_dataset.save()
        
    
if __name__ == "__main__":
    scene_config = configuration(sys.argv[1:])
    extract_scene_graphs(scene_config)
    # visualize(scene_config)