# Private-Eye (WACV 2025 Supplementary)

## Introduction
This code base contains a simple implementation of our method. It primary contains three PyTorch scripts that perform training, distillation and attack.


## Setup conda environment

1. Install MLOps environment
```
conda env create -f environment.yml
```

2. Initialize environment
```
conda activate MLOps
```

## Train Private-Eye
1. Create experiments directory
```
mkdir -p exps/celeb
```

2. Download CelebA dataset

3. Change lines in `private-eye-train.py` to reflect dataset location.

4. Run training
```
python private-eye-train.py --encoder unet-tiny --img-size 32
```


## Distill Unet-32-tiny to DONN-128

```bash
export donn="donn-10-res"
export teacher="PATH/TO/TEACHER"
python3 private-eye-donn-approx.py --epochs 10 \
    --encoder "$donn" \
    --loss-func mse \
    --mask-size 64 \
    --img-size 128 \
    --teacher_is_32 \
    --no_clamp_student \
    --teacher "$teacher" \
    --dataset '/PATH/TO/DATASET' \
    --epochs 10
```


# Attacking the encoder
```bash
export enc="donn-10-res"

# the encoder path is donn weights distilled from Unet
export enc_path="PATH/TO/ENCODER"

export enc_size=128
export classifier_size=32

python3 private-eye-attack.py --encoder "$enc" \
    --enc-img-size "$enc_size" \
    --classifier-img-size "$classifier_size" \
    --pretrained-enc "$enc_path" \
    --dataset '/PATH/TO/DATASET'\
    --epochs 10

```
