

# Relational Self-supervised Distillation with Compact Descriptors for Image Copy Detection.
The official repository for Relational Self-supervised Distillation with Compact Descriptors for Image Copy Detection.

## Pipeline

![framework](figs/framework.png)

## Implementation
- This code is implemented using Pytorch Lightning


## Datasets used
- DISC (Facebook Image Similarity Challenge 2021)
- NDEC (A Benchmark and Asymmetrical-Similarity Learning for Practical Image Copy
Detection 2023)
- CD10K(copydays + 10k distractors)

## Requirements

### Installation

```bash
pip install -r requirements.txt

```

## Teacher Models(Pretrained)
- SSCD: ResNet-50, ResNeXt101
- DINO: ViT-B/8

## Student Models
- EfficientNet-B0
- MobileNet-V3-Large
- FastViT-T12

## How to use

### docker install
```
docker build -t rdcd .
docker run --name rdcd -it --ipc=host --runtime=nvidia -v (your workspace dir):/workspace -v (your dataset dir):/data rdcd
```

### Library install
```
For training:
pip install -c faiss-gpu
For validation:
conda install -c pytorch faiss-gpu
```
### Add Teacher model
```
Place the teacher weight file into the /weights directory.
```

### Training
```
sh train.sh
```

### Evaluation
```
sh disc_eval.sh
```

## Acknowledgement

Codebase from "[SSCD](https://github.com/facebookresearch/sscd-copy-detection)" , [pytorch-image-models](https://github.com/rwightman/pytorch-image-models)
