# Negative-prompt Inversion: Fast Image Inversion for Editing with Text-guided Diffusion Models
This code is for the experiments in the paper "Negative-prompt Inversion: Fast Image Inversion for Editing with Text-guided Diffusion Models" submitted to NeurIPS 2023.

## License
It is allowed to use our code for the purpose of review.
Please also see [LICENSE](./LICENSE).

Parts of the implementation related to Prompt-to-Prompt and Null-text inversion utilize the implementation of [google/prompt-to-prompt](https://github.com/google/prompt-to-prompt), to which [LICENSE_prompt2prompt](./LICENSE_prompt2prompt) applies.

## Environment
Please use pip.
```
pip3 install -r requirements.txt
```

## Data preparation
Please download **"2017 Val images"** from [the COCO official site](https://cocodataset.org/#download), and unzip it below `data/` directory.

The captions and image names which we used for our experiments are provided as `data/captions.txt`.

After unzipping images, please run `preprocess.py` for the preprocessing of center-crop.
The preprocessed images will be saved in `data/images/` directory.
```
python3 preprocess.py
```

## Reconstruction
Please run `reconstruct.py`. The reconstructed images will be saved in `results/` directory.
```
python3 reconstruct.py
```

Arguments:
 - `--step`: set the number of sampling steps. By default, it is 50.
 - `--cfg`: set the value of CFG parameter `w`. By default, it is 7.5.
 - `--nti`: utilize null-text inversion.
 - `--npi`: utilize negative-prompt inversion.

You can use only one of `--nti` and `--npi`.
If neither of them used, images will be reconstructed by DDIM inversion and DDIM sampling with CFG, described as `DDIM Inv` in our paper's figures.


## Evaluation
Please run `eval_rec.py` to measure PSNR and LPIPS scores. The scores will be saved in `results/` directory as csv.
```
python3 eval_rec.py
```

## Editing
### Prompt-to-Prompt
Please run `edit_p2p.py` to edit by prompt-to-prompt. The edited image will be saved as `edited.png`.
```
python3 edit_p2p.py --image ./data/images/000000252559.jpg --prompt 'a number of people walking on
 a side walk near a building' --edited 'a number of people walking on a side walk near a mountain' --blend_words building mountain --replace --eq_word mountain --eq_value 2 --npi
```

Arguments:
 - `--image`: the image name.
 - `--prompt`: the prompt corresponding to the image.
 - `--edited`: the edited prompt. 
 - `--step`: set the number of sampling steps. By default, it is 50.
 - `--cfg`: set the value of CFG parameter `w`. By default, it is 7.5.
 - `--nti`: utilize null-text inversion.
 - `--npi`: utilize negative-prompt inversion.

You can use only one of `--nti` and `--npi`.
Please refer to [google/prompt-to-prompt](https://github.com/google/prompt-to-prompt) for other arguments of prompt-to-prompt.

### SDEdit
Please run `edit_sde.py`. The edited image will be saved as `output_sde.png`.
```
python3 edit_sde.py --image ./data/images/000000221693.jpg --prompt 'A black and brown doberman carries a frisbee.' --edited 'A black and brown doberman carries a frisbee in the snow.' --to 0.6 --npi
```

Arguments:
 - `--image`: the image name.
 - `--prompt`: the prompt corresponding to the image.
 - `--edited`: the edited prompt. 
 - `--t0`: the parameter of SDEdit. Please set the value between [0, 1].
 - `--step`: set the number of sampling steps. By default, it is 50.
 - `--cfg`: set the value of CFG parameter `w`. By default, it is 7.5.
 - `--nti`: utilize null-text inversion.
 - `--npi`: utilize negative-prompt inversion.

You can use only one of `--nti` and `--npi`.

### Plug-and-Play
Please run `edit_pnp.py`. The edited image will be saved as `output_pnp.png`.
This script is based on `https://github.com/MichalGeyer/pnp-diffusers` and requires `diffusers==0.17.2`.
```
python3 edit_pnp.py --image ./data/images/000000221693.jpg --prompt 'A black and brown doberman carries a frisbee.' --edited 'A black and brown doberman carries a frisbee in the snow.' --npi
```

Arguments:
 - `--image`: the image name.
 - `--prompt`: the prompt corresponding to the image.
 - `--edited`: the edited prompt. 
 - `--step`: set the number of sampling steps. By default, it is 50.
 - `--cfg`: set the value of CFG parameter `w`. By default, it is 7.5.
 - `--npi`: utilize negative-prompt inversion.

