from tqdm import tqdm
import os

from utils import load_resize_image


if __name__ == "__main__":
    # Load captions and image filenames to use the experiments
    with open("data/captions.txt", "r") as f:
        data = f.read().split("\n")[:-1]
        data = [d.split(".jpg,") for d in data]

    os.makedirs("./data/images", exist_ok=True)

    for name, caption in tqdm(data):
        # Load image, not resizing
        input_image = load_resize_image(f"data/val2017/{name}.jpg", size=None)
        input_image.save(f"data/images/{name}.jpg")
