import bm3d
import cv2
import numpy as np
import scipy
import torch
import albumentations
from skimage.transform import rescale, resize

def Gaussian(x_train, kernel_size = 3):
    # x_train: (idx, ch, w, h)
    x_train = x_train * 255
    x_train = x_train.numpy()
    x_train = np.transpose(x_train, (0, 2, 3, 1))
    for i in range(x_train.shape[0]):
        x_train[i] = cv2.GaussianBlur(x_train[i], (kernel_size, kernel_size),0)
    x_train = x_train / 255.
    x_train = np.transpose(x_train, (0, 3, 1, 2))
    x_train = torch.from_numpy(x_train)
    return x_train


def BM3D(x_train, sigma=0.5):
    x_train = x_train * 255
    x_train = x_train.numpy()
    x_train = np.transpose(x_train,(0,2,3,1))
    for i in range(x_train.shape[0]):
        x_train[i] = bm3d.bm3d(x_train[i], sigma_psd=sigma)
    x_train = x_train / 255.
    x_train = np.transpose(x_train, (0, 3, 1,2))
    x_train = torch.from_numpy(x_train)
    return x_train


def Wiener(x_train, kernel_size = 3):
    x_train = x_train * 255
    x_train = x_train.numpy()

    for i in range(x_train.shape[0]):
        img = x_train[i]
        windows_size = (kernel_size, kernel_size)
        img[0] = scipy.signal.wiener(img[0], windows_size)
        img[1] = scipy.signal.wiener(img[1], windows_size)
        img[2] = scipy.signal.wiener(img[2], windows_size)
        x_train[i] = img
    x_train /= 255.
    x_train = torch.from_numpy(x_train)
    return x_train

def jpeg_compress(x_train, quality = 90): #0~100
    compression_param = [cv2.IMWRITE_JPEG_QUALITY, quality]
    x_train = x_train * 255
    x_train = x_train.numpy()
    x_train = np.transpose(x_train, (0, 2, 3, 1))
    for i in range(x_train.shape[0]):
        _, compressed_image = cv2.imencode('.jpg', x_train[i], [int(cv2.IMWRITE_JPEG_QUALITY), quality])
        x_train[i] = cv2.imdecode(compressed_image, 1)
    x_train = x_train / 255.
    x_train = np.transpose(x_train, (0, 3, 1, 2))
    x_train = torch.from_numpy(x_train)
    return x_train

def smoothing(data, smooth_type):
    if smooth_type == 'gaussian':
        data = Gaussian(data, kernel_size=3)
    elif smooth_type == 'wiener':
        data = Wiener(data, kernel_size=3)
    elif smooth_type == 'BM3D':
        data = BM3D(data, sigma=0.5)
    elif smooth_type == 'jpeg':
        data = jpeg_compress(data, quality=90)  # 50, 90
    elif smooth_type == 'no_smooth':
        data = data
    else:
        raise Exception(f'Error, unknown smooth_type{smooth_type}')

    return data

