# Low-Frequency Black-Box Backdoor Attack via Evolutionary Algorithm (LFBA)

### This code is implemented in PyTorch, and we have tested the code under the following environment settings:
python = 3.11.5
torch = 2.1.1
torchvision = 0.16.1

### Step 1: Prepare  datasets  into ./data
We test five public datasets in this work.
### Download GTSRB dataset
bash gtsrb_download.sh

### Step 2: Train clean models
    Train clean model:
        $ python train_clean.py --model ["cnn_mnist","preact_resnet","resnet"] --data ["mnist","cifar10","gtsrb","imagenet","celeba"] --epochs 200

### Step 3: Train baseline backdoor models
    Train attack baslines:
    	$ python train_atatck.py --model ["cnn_mnist","preact_resnet","resnet"] --data ["mnist","cifar10","gtsrb","imagenet","celeba"] --attack_mode ["square", "sig", "ftrojan", "fiba"] --poison_ratio 0.05 --epochs 200

### Step 4: Train backdoor model with frequency attack
    Train our LFBA attack:
        $ python train_freq_atatck.py --model ["cnn_mnist","preact_resnet","resnet"] --data ["mnist","cifar10","gtsrb","imagenet","celeba"] --attack_mode ["freq"] --poison_ratio 0.05 --epsilon [0.1,0.5,1.5] --epochs 200

## Evaluation (defenses/natural stealthiness/image preprocessing)

### Test Natural Stealthiness
    $ python natural_stealthiness.py --data ["cifar10","gtsrb","imagenet","celeba"]

### Test STRIP
    $ python strip.py --model ["cnn_mnist","preact_resnet","resnet"] --data ["mnist","cifar10","gtsrb","imagenet","celeba"] --attack_mode ["square", "sig", "ftrojan", "fiba","freq"]

### Test Fine-pruning
    $ python fine_pruning.py --model ["preact_resnet","resnet"] --data ["cifar10","gtsrb","imagenet","celeba"] --attack_mode ["square", "sig", "ftrojan", "fiba","freq"]

### Test Neural Cleanse
    $ python neural_cleanse.py --data ["mnist","cifar10","gtsrb","imagenet","celeba"] --model ["cnn_mnist","preact_resnet","resnet"] --attack_mode ["square", "sig", "ftrojan", "fiba","freq"]

### Test Image Preprocessing
    $ python preprocess.py --data ["cifar10","gtsrb","imagenet","celeba"] --model ["preact_resnet","resnet"] --attack_mode ["square", "sig", "ftrojan", "fiba","freq"] --smooth_type ["no_smooth","gaussian","wiener","BM3D","jpeg"]
