# Where is the Watermark?
**Interpretable Watermark Detection at the Block Level**

A post-hoc image-watermarking toolbox that embeds an invisible, block-wise watermark in the DWT domain and allows for localised detection of the watermark.
![Embedding and Detection Pipeline](Examples/emb_det_scheme.png)

## 📋 Contents
- `embed_main.py` – Main script to watermark an image
- `detect_main.py` - Main script to detect a watermark in an image 
- `utils.py` & `embed_utils.py` & `detect.py` & `detect_utils.py` & `eval.py` & `entropy_utils.py` – Internal helper routines

## 💧 Embedding the Watermark
Use `embed_main.py` to embed watermarks into images:
```
python embed_main.py input_image.jpg output_watermarked.png [options]
```

### Parameters:

`image_path`: Path to the input image file  
`output_path`: Path where the watermarked image will be saved  
`--dwt_lvl`: DWT decomposition level (default: 3)  
`--round`: Round parameter for seed calculation (default: 30)  
`--num_keys`: Number of keys for embedding (default: 0)  
`--entropy_threshold`: Minimum entropy threshold for processing blocks. If not specified, uses median entropy of the image.

### Example:
```
python embed_main.py Examples/Test_image.png Examples/Test_image_wm.png --dwt_lvl 3 --round 30 --entropy_threshold 0
```


## 🔍 Detecting the Watermark

Use `detect_main.py` to detect watermarks in images and to obtain a localised detection map:  
```
python detect_main.py watermarked_image.png [options]
```

### Parameters:

`image_path`: Path to the input image file  
`--dwt_lvl`: DWT decomposition level (default: 3, should match embedding)  
`--round`: Round parameter for detection (default: 30, should match embedding)  
`--entropy_threshold`: Minimum entropy threshold for processing blocks. If not specified, uses median entropy of the image    
`--postprocess`: Apply map postprocessing to fill isolated blocks (default: True)  
`--no-postprocess`: Disable postprocessing

## 📦 Installation

### Using pip with requirements.txt
```bash
pip install -r requirements.txt
```

## 📄 License
This project is licensed under the MIT License - see the LICENSE file for details.
