import cv2
import numpy as np

def compute_entropy(square):
    """
    Compute Shannon entropy of a given image square.
    """
    # Convert to grayscale if needed
    if square.ndim == 3 and square.shape[2] == 3:
        square = cv2.cvtColor(square, cv2.COLOR_RGB2GRAY)
    hist, _ = np.histogram(square, bins=256, range=(0, 256), density=True)
    hist_nonzero = hist[hist > 0]
    return -np.sum(hist_nonzero * np.log2(hist_nonzero))

def compute_entropy_threshold(image, square_size=96):
    """
    Compute the median entropy of an image by splitting it into squares.
    """
    h, w = image.shape[:2]
    entropies = []
    for y in range(0, h, square_size):
        for x in range(0, w, square_size):
            square = image[y:y+square_size, x:x+square_size]
            entropies.append(compute_entropy(square))
    return np.median(entropies)
