# Deep Image Decompositioin For Medical Imaging Anonymization And Curation (Paper ID 1697)

This project implements a deep learning framework for detecting and removing text from images using a combination of classification, localization, and image decomposition techniques. The system uses GradCAM for text localization and a dual generator architectures for text removal and restoring the underlying content.

## Project Overview

The project consists of two main components:

1. **Text Detection and Localization**: A two-tail classifier that determines whether an image contains text and uses GradCAM to localize text regions
2. **Decomposition**: A dual generator system that removes detected text from images while preserving the background and restore medical data

## Architecture

### Models

- **TwoTailClassifier**: A CNN-based classifier for detecting text presence in images
- **UNet**: Generator networks for text removal and text detection
- **LinearDiscriminator**: Discriminator networks for GAN training
- **GradCAM**: Class activation mapping for text localization

### Training Framework

1. **Detection and Localization Training**: Trains the classifier and generates GradCAM heatmaps
2. **Decomposition Training**: Trains the dual generator text removal system using the localized text regions

## Installation

1. **Install dependencies**:
   ```bash
   pip install -r requirements.txt
   ```

2. **Set up environment variables**:
   Copy `.env.empty` to `.env` and fill in your configuration values.

3. **Run**:
   To run the complete training framework (detection + decomposition) along with its test
   ```bash
   python run.py
   ```