This repository contains scripts to run experiments for the WACV paper "Performance of Conformal Prediction in Capturing Aleatoric Uncertainty":

Due to submission file size limits (which is 200MB), only the CIFAR-10H dataset (Peterson, J. C., Battleday, R. M., Griffiths, T. L., & Russakovsky, O. (2019). Human uncertainty makes classification more robust. In Proceedings of the IEEE/CVF international conference on computer vision (pp. 9617-9626).) is included with this repository. The rest of the datasets can be downloaded followig the respective papers.

- [CIFAR-10H](https://openaccess.thecvf.com/content_ICCV_2019/html/Peterson_Human_Uncertainty_Makes_Classification_More_Robust_ICCV_2019_paper.html)
- [MLRSNet](https://www.sciencedirect.com/science/article/pii/S0924271620302677)
- [FER+](https://dl.acm.org/doi/abs/10.1145/2993148.2993165)
- [ImageNet-ReaL](https://arxiv.org/abs/2006.07159)

Outputs are written to the results directory.

---

## Quick Start

```bash
python -m venv .venv
source .venv/bin/activate        # on Windows: .venv\Scripts\activate
python -m pip install --upgrade pip
python -m pip install -r requirements.txt

python main.py --dataset cifar10h
python main.py --dataset mlrsnet
python main.py --dataset ferplus
python main.py --dataset imagenet-real
```
/
├─ main.py
├─ config/
│  └─ paths.py
├─ src/
│  ├─ run_cifar10h.py
│  ├─ run_mlrsnet.py
│  ├─ run_ferplus.py
│  └─ run_imagenet_real.py
├─ scripts/
│  └─ check_imports.py
├─ requirements.txt
├─ .gitignore
└─ data/
   ├─ cifar10h/
   ├─ mlrsnet/
   ├─ ferplus/
   └─ imagenet-real/

### Datasets
data/cifar10h/
├─ cifar10h-counts.npy
├─ cifar10h-probs.npy
└─ cifar-10-batches-py/

data/mlrsnet/
├─ Images/
└─ labels/
   ├─ *.csv

data/ferplus/
├─ fer-pytorch/fer_pytorch/dataset/
│  ├─ new_train.csv
│  ├─ new_val.csv
│  ├─ new_test.csv
│  └─ data/
│     ├─ FER2013Train/
│     ├─ FER2013Valid/
│     └─ FER2013Test/
├─ fer2013new.csv
└─ models_refined/
   └─ {resnet18,resnet34,resnet50,vgg16,vgg19,densenet121,densenet161,mobilenet_v2}.pth

data/imagenet-real/
└─ downloads/

### Run Examples
```bash
python main.py --dataset cifar10h
python main.py --dataset mlrsnet --data-root /mnt/datasets --out ./results
DATA_ROOT=/mnt/datasets python main.py --dataset ferplus
python main.py --dataset imagenet-real
```