import os
from pathlib import Path
from typing import Optional
from datetime import datetime

def _root(default: str, override: Optional[str], env: str) -> Path:
    if override:
        return Path(override).expanduser().resolve()
    if (v := os.environ.get(env)):
        return Path(v).expanduser().resolve()
    return Path(default).resolve()

# def resolve_paths(dataset: str, data_root: Optional[str], out_root: str):
def resolve_paths(dataset: str, data_root: Optional[str], out_root: str, model_name: Optional[str] = None):
    data = _root("./data", data_root, "DATA_ROOT")
    out = Path(out_root).expanduser().resolve()
    ds_map = {
        "cifar10h": data / "cifar10h",
        "mlrsnet": data / "mlrsnet",
        "ferplus": data / "ferplus",
        "imagenet-real": data / "imagenet-real",
    }
    ds_dir = ds_map[dataset]
    out_dir = out / dataset
    stamp = datetime.now().strftime("%Y%m%d-%H%M%S")
    
    folder_name = f"{stamp}_{model_name}" if model_name else stamp
    results = out_dir / folder_name
    
    # results = out_dir / stamp
    # results.mkdir(parents=True, exist_ok=True)
    return {
        "data_root": data,
        "dataset_dir": ds_dir,
        "results_dir": results,
    }
