import argparse
import subprocess
from pathlib import Path

def parse_args():
    p = argparse.ArgumentParser(description="run experiments on multiple datasets")
    p.add_argument("--dataset", required=True,
                   choices=["cifar10h", "mlrsnet", "ferplus", "imagenet-real"],
                   help="which dataset to run")
    p.add_argument("--data-root", default=None,
                   help="root directory containing datasets (default ./data or $DATA_ROOT)")
    p.add_argument("--out", default="./results",
                   help="output directory for results")
    return p.parse_args()


def main():
    from config.paths import resolve_paths  # keep your original import here
    args = parse_args()

    paths = resolve_paths(args.dataset, data_root=args.data_root, out_root=args.out)

    if args.dataset == "cifar10h":
        from src.run_cifar10h import run
    elif args.dataset == "mlrsnet":
        from src.run_mlrsnet import run
    elif args.dataset == "ferplus":
        from src.run_ferplus import run
    else:
        from src.run_imagenet_real import run
    run(paths, args)

if __name__ == "__main__":
    main()
