import ast, importlib, sys
from pathlib import Path

def find_imports(root: Path):
    mods = set()
    for p in root.rglob("*.py"):
        try:
            tree = ast.parse(p.read_text(encoding="utf-8"))
        except Exception:
            continue
        for node in ast.walk(tree):
            if isinstance(node, ast.Import):
                for n in node.names:
                    mods.add(n.name.split(".")[0])
            elif isinstance(node, ast.ImportFrom) and node.module:
                mods.add(node.module.split(".")[0])
    third_party_missing = []
    for m in sorted(mods):
        try:
            importlib.import_module(m)
        except Exception:
            third_party_missing.append(m)
    return third_party_missing

if __name__ == "__main__":
    root = Path(sys.argv[1]) if len(sys.argv) > 1 else Path(".")
    missing = find_imports(root)
    if missing:
        print("missing modules (pip install these):")
        for m in missing:
            print(" -", m)
        sys.exit(1)
    else:
        print("no missing third-party imports detected.")
