# ZonUI-3B Evaluation Instruction
## 🔧Install Environment

```
conda create -n zonui python=3.10
conda activate zonui
pip install torch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 --index-url [PyTorch_CUDA_URL] --user
pip install -r requirements.txt --user
```

## 📦Setup Datasets
- Download grounding evaluation dataset -- ScreenSpot and ScreenSpot-v2

You can use git clone to download these datasets easily:
```bash
# Navigate to datasets directory and download
export DATA_DIR="./datasets"          # Dataset directory
cd $DATA_DIR

huggingface-cli download [SCREENSPOT_AUTHOR]/ScreenSpot --repo-type dataset --local-dir ScreenSpot
git clone [ScreenSpot_v2_URL]

# Return to project directory
cd ..
```
> **Note**: Dataset URLs are listed in `links.txt`
### 📈 Monitoring and Evaluation

- **Training Monitoring**: Monitor training progress through your Wandb dashboard, Make sure to set your `wandb_key` in `eval_ss.sh` and `eval_ss2.sh`
- **Evaluation Scripts**: We provide evaluation scripts for `ScreenSpot` and `ScreenSpot-v2` benchmarks. To evaluate on `ScreenSpot-Pro`, please follow the instructions from the official repository (see `links.txt`).
  - `main/eval_screenspot.py` - Main evaluation script
  - `eval_ss.sh` - Evaluation script for ScreenSpot dataset (evaluation-only mode)
  - `eval_ss2.sh` - Evaluation script for ScreenSpot-v2 dataset (evaluation-only mode)
  - `ScreenSpot-Pro` - Follow the official ScreenSpot-Pro repository: screenspot-pro (see `links.txt`)

#### Running Evaluation Only
To run evaluation without training, use the provided evaluation scripts:
```bash
# Make sure to set LoRA rank to 0 for evaluation
chmod +x eval_ss.sh
./eval_ss.sh
```

**Important Notes:**
- **For evaluation only**: Use `--eval_only` flag and set `--lora_r=0` to disable LoRA modifications
- The evaluation scripts (`eval_ss.sh`, `eval_ss2.sh`) are pre-configured for evaluation-only mode
