#!/bin/bash
deepspeed train.py \
  --wandb_key="" \
  --model_id='Qwen/Qwen2.5-VL-3B-Instruct' \
  --version='Qwen/Qwen2.5-VL-3B-Instruct' \
  --dataset_dir="./datasets/" \
  --log_base_dir="./logs/" \
  --epochs=12 \
  --steps_per_epoch=122 \
  --batch_size=1 \
  --grad_accumulation_steps=48 \
  --model_max_length=4096 \
  --exp_id="debug" \
  --train_ratio="1.0" \
  --train_dataset="uground"  \
  --train_json="hf_train"   \
  --eval_train_dataset="training-eval"  \
  --eval_train_json="hf_train"  \
  --val_dataset="screenspot"  \
  --val_json="hf_test_full"  \
  --precision="bf16" \
  --attn_imple="sdpa" \
  --workers=0 \
  --lora_r=8 \
  --lora_alpha=16  \
  --min_visual_tokens=256  \
  --max_visual_tokens=1280  \
  --num_turn=30 \
  --crop_min=1 \
  --crop_max=1 \
  --record_sample \
  --random_sample \
  --lr=0.00005 \
  --warmup_steps=122 \
  --ds_zero="zero2" \
  --gradient_checkpointing  \
  --uniform_prompt \
  --local_weight \
  --local_weight_dir=/path/to/stage1/merged_model/