# Supplementary material
## Sparse Layered Graphs for Multi Object Segmentation

This folder contains a set of Jupyter notebooks and Python code for creating 
and solving sparse layered graphs using s-t graph cut.

Data, code and notebooks available at: DOI 10.11583/DTU.12016941

# Content

## ```slgbuilder```
For the latest version of ```slgbuilder``` see https://github.com/Skielex/slgbuilder.

This folder contains our Python code for creating sparse layered graphs (SLGs).
This includes the two general methods described in the paper for adding
interaction constraints on SLGs. The functions implementing these are:
 - ```add_containment```
 - ```add_exclusion```

The functions implementing the three algorithms for adding interactions
on ordered multi-column SLGs with few redundant terms are implemented in:
 - ```add_layered_containment```
 - ```add_layered_exclusion```

Dependencies for using the ```slgbuilder``` module can be installed using ```pip```.

```pip install numpy scipy scikit-learn thinmaxflow thinqpbo```

*The notebooks below have addtional dependencies that are not listed here.*

## ```DetectLayers.ipynb```
A basic example of using the ```slgbuilder``` module for layered surface detection.

*Not directly used in the article.*

## ```DetectObjects.ipynb```
A basic example of using the ```slgbuilder```  module for object segmentation with
and without exclusion.

*Not directly used in the article.*

## ```NerveSegmentation2DPart1.ipynb```
Experiment setup and execution for 2D nerve segmentation using three different methods.
The results are saved to disk and used in ```NerveSegmentation2DPart2.ipynb```. Beware
this notebook takes a long time to run and may use a lot of memory.

## ```NerveSegmentation2DPart2.ipynb```
Analysis of 2D nerve segmentation results from ```NerveSegmentation2DPart1.ipynb```.

*Used in the paper Table 1 and Figure 5 and 6.*

## ```NerveSegmentation3D.ipynb```
Experiment setup and execution for 3D nerve segmentation using RC-SLG. Beware
this notebook takes a long time to run and use a lot of memory.

*Used for paper Figure 7.*

## ```NucleiSegmentationPart1.ipynb```
Preparation of nuclei data used in ```NucleiSegmentationPart2a.ipynb``` and
```NucleiSegmentationPart2b.ipynb```. Download link in notebook.

## ```NucleiSegmentationPart2a.ipynb```
Experiment setup and execution of nuclei segmentation using a 4N-SLG.
The results are saved to disk and used in ```NucleiSegmentationPart3.ipynb```. Beware
this notebook takes a long time to run and may use a lot of memory.

## ```NucleiSegmentationPart2b.ipynb```
Experiment setup and execution of nuclei segmentation using a RC-SLG.
The results are saved to disk and used in ```NucleiSegmentationPart3.ipynb```. Beware
this notebook takes a long time to run and may use a lot of memory.

## ```NucleiSegmentationPart3.ipynb```
Analysis of nuclei segmentation results from ```NucleiSegmentationPart2a.ipynb```
and ```NucleiSegmentationPart2b.ipynb```. Beware this notebook takes a long time to run.

*Used in the paper Table 2 and Figure 8 and 9.*

## ```data```
Folder containing image data used in notebooks.

## ```nerve_comparison_2d_data```, ```nerve_3d_data``` and ```nuclei_comparison_data```
Empty folders used to store data temporary data and results.
