#### Document Description

+ 'util.py' loads data for CUB, AwA1, AwA2, SUN and FLO dataset;

+ 'demo.py' contains the test code for evaluating the model performance on GZSL and ZSL. The parameters are specified as follows:

  '--gzsl'   determines testing mode:  generalized ZSL or conventional ZSL;

  '--syn_num' controls the synthetic number for each class;

  '--classifier_lr' controls the learning rate to train final softmax classifier;

  '--attSize' is the dimension of class embedding according to the specific dataset;

  '--nclass' is the total class number for current dataset;

+ `model.py' contains the various model classes for generator and discriminators.

+ `classifier.py' contains the code for constructing the final softmax classifier by use of fake features synthesized by a trained generator. It also provides the specific procedure to calculate the seen accuracy, unseen accuracy and harmonic mean.

#### Data Preparation

Download the dataset,  and set the data path on your computer in 'demo.py' before running. 
The dataset should contains:
(1) the 2048-D visual feautre for each image extracted by Res-net101
(2) the attribute label for each class, which is 312-D for CUB, 85-D for AwA1 and AwA2,  102-D for SUN, 1024-D for FLO.

#### Run the Code

First, choose one dataset and set the parameter list according to the dataset. For example, to run the CUB dataset under GZSL setting, we should run:

 python demo.py   --gpu 0,1,2,3   --dataset CUB  --cls_weight 0.01 --nepoch 300   --lr 0.0001  --nclass_all 200 --nz 312   --attSize 312   --syn_num 300
where "0,1,2,3" specifies your gpu IDs. 