clc
clear
close all
addpath(genpath('../'))



%% LOAD HAND MODEL

load('hand_model.mat');
[hand_model] = reindex_fullhand(hand_model);

%hand_model.palm_wrist_centers_relative{13} = hand_model.palm_wrist_centers_relative{13} + [0;4;0];
%hand_model.palm_wrist_radii{13} = hand_model.palm_wrist_radii{13} - 2.0;
%hand_model.palm_wrist_radii{14} = hand_model.palm_wrist_radii{14} - 3.0;

%hand_model = update_centers(hand_model);

settings.D = 3;
settings.block_safety_factor = 1.3

%% OPTIMIZE OVER VALIDITY

[F,Jc,Jr,Jc_f,Jr_f] = COMPUTE_VALIDITY_ENERGY(hand_model, settings)

display_model(hand_model, 0.9, 'big')


